import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;


/**
 * TODO Put here a description of what this class does.
 *
 * @author drososmj.
 *         Created Apr 15, 2008.
 */
public class Polygon implements Tool {
	
	private Point2D.Double firstClick;
	/**
	 * TODO Put here a description of this field.
	 */
	protected ArrayList<Shape> shapes;
	private boolean previousBool;
	private Point2D.Double previousPoint;
	private ArrayList<Boolean> fill;
	private ArrayList<Color> color;
	private ColorPanel colorPanel;
	private Color permColor;
	/**
	 * a polygon that can be drawn by individual points(end by clicking within a 5 pixel radius of the start point)
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param color - an ArrayList of colors of the corresponding shapes
	 * @param colorPanel - allows access to color panel functions
	 */
	public Polygon(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel)
	{
		this.shapes = shapes;
		this.fill = fill;
		this.color = color;
		this.colorPanel = colorPanel;
		this.permColor = this.colorPanel.getCurrentColor();
		
	}
	
	public void clicked(MouseEvent event) {
		
		if(!this.previousBool)
		{
			this.shapes.add(new Ellipse2D.Double(event.getX(), event.getY(), 0.01,0.01));
			this.fill.add(true);
			this.color.add(this.colorPanel.getCurrentColor());
			this.permColor = this.colorPanel.getCurrentColor();
			
			this.firstClick = new Point2D.Double(event.getX(), event.getY());
			this.previousBool = true;
			this.previousPoint = new Point2D.Double(event.getX(), event.getY());
		}
		else
		{
			if(Math.sqrt(Math.pow(this.firstClick.getX() - event.getX(),2) + Math.pow(this.firstClick.getY() - event.getY(),2)) <= 5)
			{
				this.shapes.add(new Line2D.Double(this.previousPoint.getX(), this.previousPoint.getY(), this.firstClick.getX(), this.firstClick.getY()));
				this.fill.add(false);
				this.color.add(this.permColor);
				this.previousBool = false;
			}
			else
			{
				this.shapes.add(new Line2D.Double(event.getX(), event.getY(), this.previousPoint.getX(), this.previousPoint.getY()));
				this.fill.add(false);
				this.color.add(this.permColor);
				this.previousPoint = new Point2D.Double(event.getX(), event.getY());
			}
		}
	}

	public void dragged(MouseEvent event) {
		// TODO Auto-generated method stub.

	}

	public void pressed(MouseEvent event) {
//		 TODO Auto-generated method stub.
	}

	public void release(MouseEvent event) {
		// TODO Auto-generated method stub.
	}

}
