import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;


/**
 * This class creates the menu bar at the top of paint.
 *
 * @author Jared Mathis.
 *         Created Apr 13, 2008.
 */
public class PaintMenu extends JMenuBar implements MouseListener {

	private Paint paint;
	
	
	/**
	 * The "Undo" menu item.  It's protected so that drawSpace can enable/disable it.
	 */
	protected JMenuItem undo;
	
	/**
	 * The "Redo" menu item.  It's protected for the same reason undo is.
	 */
	protected JMenuItem redo;
	
	

	/**
	 * This constructs the menu bar.
	 *
	 * @param paint The Paint object for which this menu bar belongs.
	 */
	public PaintMenu(Paint paint) {
		super();
		
		this.paint = paint;
		
		JMenuItem newFile = new JMenuItem("New", 'N');
		newFile.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));
		newFile.addActionListener(this.paint.drawSpace);
		
		JMenuItem open = new JMenuItem("Open", 'O');
		open.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
		open.addActionListener(this.paint.drawSpace);
		
		JMenuItem save = new JMenuItem("Save", 'S');
		save.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
		save.addActionListener(this.paint.drawSpace);
				
		JMenuItem quit = new JMenuItem("Quit", 'Q');
		quit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, ActionEvent.ALT_MASK));
		quit.addActionListener(this.paint.drawSpace);
		
		JMenu file = new JMenu("File");
		file.add(newFile);
		file.add(open);
		file.add(save);
		file.add(quit);
		file.addMouseListener(this);
		
		
		JMenuItem invert = new JMenuItem("Invert", 'I');
		invert.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, ActionEvent.CTRL_MASK));
		invert.addActionListener(this.paint.drawSpace);
		
		JMenuItem size = new JMenuItem("Resize", 'R');
		size.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));
		size.addActionListener(this.paint.resizer);
		
		JMenu image = new JMenu("Image");
		image.add(invert);
		image.add(size);
		image.addMouseListener(this);
		
		
		this.undo = new JMenuItem("Undo", 'Z');
		this.undo.addActionListener(this.paint.drawSpace);
		this.undo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z, ActionEvent.CTRL_MASK));
		this.undo.setEnabled(false);
		
		this.redo = new JMenuItem("Redo", 'Y');
		this.redo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y, ActionEvent.CTRL_MASK));
		this.redo.addActionListener(this.paint.drawSpace);
		this.redo.setEnabled(false);

		
		JMenu edit = new JMenu("Edit");
		edit.add(this.undo);
		edit.add(this.redo);
		edit.addMouseListener(this);
		
		
		this.add(file);
		this.add(edit);
		this.add(image);
	}




	public void mouseClicked(MouseEvent e) { /* empty */ }
	public void mouseReleased(MouseEvent e) { /* empty */ }
	public void mouseEntered(MouseEvent e) { /* empty */ }
	public void mouseExited(MouseEvent e) { /* empty */ }

	public void mousePressed(MouseEvent e) {
		this.paint.toolPanel.endCurrentTool();		
	}



	
	

}
