import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;


/**
 * This class is a subclass of JButton.
 * It is made to make a SubFunction button.
 *
 * @author baekj.
 *         Created Apr 14, 2008.
 */
public class SubFunctionClass extends JButton implements ActionListener{

	private int code;
	private DrawingPanel drawing;
	/**
	 * This constructor creates a button that enables the user to change
	 * the size and form of the brush in Paint.
	 * 
	 * @param msg the name of the button
	 * @param drawing the instance of the panel for drawing. This is brought 
	 * into this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 * @param code the number that lets the method in DrawingPanel know which
	 *  button is pressed.
	 */
	public SubFunctionClass(String msg,DrawingPanel drawing, int code){
		super(msg);
		this.drawing = drawing;
		this.code = code;
		this.addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
		this.drawing.setSubFunctionCode(this.code);
	}
}
