import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;


/**
 * This class is a subclass of JButton.
 * It is made to make a RectangleButton.
 * 
 * @author baekj. Created Apr 7, 2008.
 */
public class SprayUndoClear extends JButton implements ActionListener{
	private DrawingPanel bla;
	private int code;
	/**
	 * This constructor creates a button that will enable the user to use the 
	 * Rectangle function in Paint.
	 *
	 * @param bla the instance of the panel for drawing. This is brought into 
	 * this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 * @param code Allows the logic in actionPerformed to choose the method to
	 * be used in Drawing panel.
	 */
	public SprayUndoClear(DrawingPanel bla, int code){
		super();
		this.code = code;
		this.bla = bla;
		this.setVisible(true);
	}
	public void actionPerformed(ActionEvent e) {
		//spray
		if(this.code == 1){
			this.bla.buttonRecChanger(5);
		}
		//undo
		else if(this.code == 2){
			this.bla.undo();
		}
		//clear
		else if(this.code == 0){
			this.bla.clearImage();
		}
	}

}