
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

import javax.swing.JComponent;


/**
 * The canvas that is being drawn on.
 *
 * @author LPrestonSegoIII
 * 		   Kyle Harris
 *         Created Mar 27, 2008.
 */
public class CanvasComponent extends JComponent implements MouseListener, MouseMotionListener{
	
	private Point lastMousePos;
	private String activeTool = "Pencil";
	private int brushSize = 2;
	private Color chosenColor = Color.BLACK;
	Graphics g2 = getGraphics();
	ArrayList polyArray = new ArrayList<Point>();
	
	/**
	 * Constructor.
	 * @param toolsComponent 
	 *
	 */
	public CanvasComponent() {
		super();
		addMouseMotionListener(this);
		addMouseListener(this);
	}
	
	@Override
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		addMouseMotionListener(this);
		addMouseListener(this);

	}
    
	public void mouseClicked(MouseEvent e) {
		System.out.println("This is gay");
		this.lastMousePos = e.getPoint();
		if(this.activeTool.equals("Polygon")){
			this.polyArray.add(e.getPoint());
			if(this.polyArray.size() > 1){
				for (int i = 0; i < this.polyArray.size() - 1; i++){
					Point firstPoint = ((Point)this.polyArray.get(i));
					Point secondPoint = ((Point)this.polyArray.get(i+1));
					this.g2.drawLine(firstPoint.x, firstPoint.y, secondPoint.x, secondPoint.y);
				}
			}
		}
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mousePressed(MouseEvent e) {

	}
	
	public void mouseReleased(MouseEvent e) {
		Point p = e.getPoint();
		Point firstPoint = new Point(Math.min(p.x, this.lastMousePos.x), Math.min(p.y, this.lastMousePos.y));
		if(this.activeTool.equals("Rectangle")){
			this.g2.drawRect(firstPoint.x, firstPoint.y, Math.abs(p.x - this.lastMousePos.x), Math.abs(p.y - this.lastMousePos.y));
		}
		else if(this.activeTool.equals("Ellipse")){
			this.g2.drawOval(firstPoint.x, firstPoint.y, Math.abs(p.x - this.lastMousePos.x), Math.abs(p.y - this.lastMousePos.y));
		}
	}

	public void mouseDragged(MouseEvent e) {
		Point p = e.getPoint();
		Graphics g = getGraphics(); 
		this.g2 = g;
		if (this.activeTool.equals("Eraser")) {
			g.setColor(Color.WHITE); 
		} else g.setColor(this.chosenColor);
		
		if (this.activeTool.equals("Pencil")){
			g.drawLine(this.lastMousePos.x, this.lastMousePos.y, p.x, p.y);
		} 
		else if (this.activeTool.equals("Paint Brush") || this.activeTool.equals("Eraser")){
			for (int i = 0; i < p.distance(this.lastMousePos); i++){
				double dy = i * Math.sin(Math.atan2(this.lastMousePos.y - p.y, this.lastMousePos.x - p.x));
				double dx = i * Math.cos(Math.atan2(this.lastMousePos.y - p.y, this.lastMousePos.x - p.x));
				g.fillOval((int)dx + p.x - this.brushSize/2, (int)dy + p.y - this.brushSize/2, this.brushSize, this.brushSize);

			}
		}
		if(this.activeTool.equals("Rectangle") || this.activeTool.equals("Ellipse")){
			/*nothing here*/
			} else {
				this.lastMousePos = p;
				}
	}

	public void mouseMoved(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}
	
	/**
	 * Chooses the current tool being used in the canvas.
	 *
	 * @param tool
	 */
	public void chooseTool(String tool) {
		this.activeTool = tool;
	}

	/**
	 * Chooses the current brush size.
	 *
	 * @param brushSize2
	 */
	public void changeBrushSize(int brushSize2) {
		this.brushSize = brushSize2;
		
	}
	
	/**
	 * Sets the Color
	 *
	 * @param color
	 */
	public void changeChosenColor(Color color){
		this.chosenColor = color;
		this.getGraphics().setColor(this.chosenColor);
	}

}
