import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;


/**
 * a button that allows tools to be drawn to the window
 *
 * @author Matthew Drosos and Colin DeClue.
 *         Created Apr 9, 2008.
 */
public class ToolButton extends JButton implements ActionListener{
	
	private ToolPanel toolPanel;
	private Tool tool;

	/**
	 * a button that allows different tools to be selected
	 *
	 * @param toolPanel - a panel of ToolButtons
	 * @param tool - a tool used to interact with the world panel
	 */
	public ToolButton(ToolPanel toolPanel, Tool tool)
	{
		this.toolPanel = toolPanel;
		this.tool = tool;
	}

	public void actionPerformed(ActionEvent e) {
		this.toolPanel.setCurrentTool(this.tool);
	}

}
