import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JPanel;


/**
 * allows the color to be changed on a panel
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 13, 2008.
 */
public class ColorPanel extends JPanel {
	private Color currentColor;
	
	/**
	 * creates a new ColorPanel with colors(black, red, blue, green, cyan, gray, orange, yellow, white, magenta)
	 *
	 * @param color - takes an ArrayList of Colors
	 */
	public ColorPanel()
	{
		GridLayout grid = new GridLayout(10, 1);
		
		this.currentColor=Color.BLACK;
		ColorButton red = new ColorButton(this,Color.RED);
		red.setBackground(Color.red);
		red.addActionListener(red);
		red.setPreferredSize(new Dimension(50, 20));
		this.add(red);
		ColorButton blue = new ColorButton(this,Color.blue);
		blue.setBackground(Color.blue);
		blue.addActionListener(blue);
		blue.setPreferredSize(new Dimension(50, 20));
		this.add(blue);
		ColorButton black = new ColorButton(this,Color.black);
		black.setBackground(Color.black);
		black.addActionListener(black);
		black.setPreferredSize(new Dimension(50, 20));
		this.add(black);
		ColorButton green = new ColorButton(this,Color.green);
		green.setBackground(Color.green);
		green.addActionListener(green);
		green.setPreferredSize(new Dimension(50, 20));
		this.add(green);
		ColorButton cyan = new ColorButton(this,Color.cyan);
		cyan.setBackground(Color.cyan);
		cyan.addActionListener(cyan);
		cyan.setPreferredSize(new Dimension(50, 20));
		this.add(cyan);
		ColorButton gray = new ColorButton(this,Color.gray);
		gray.setBackground(Color.gray);
		gray.addActionListener(gray);
		gray.setPreferredSize(new Dimension(50, 20));
		this.add(gray);
		ColorButton orange = new ColorButton(this,Color.orange);
		orange.setBackground(Color.orange);
		orange.addActionListener(orange);
		orange.setPreferredSize(new Dimension(50, 20));
		this.add(orange);
		ColorButton yellow = new ColorButton(this,Color.yellow);
		yellow.setBackground(Color.yellow);
		yellow.addActionListener(yellow);
		yellow.setPreferredSize(new Dimension(50, 20));
		this.add(yellow);
		ColorButton white = new ColorButton(this,Color.white);
		white.setBackground(Color.white);
		white.addActionListener(white);
		white.setPreferredSize(new Dimension(50, 20));
		this.add(white);
		ColorButton magenta = new ColorButton(this,Color.magenta);
		magenta.setBackground(Color.magenta);
		magenta.addActionListener(magenta);
		magenta.setPreferredSize(new Dimension(50, 20));
		this.add(magenta);
		this.setLayout(grid);
	}
	
	/**
	 *
	 * @return - returns the current color selection
	 */
	public Color getCurrentColor()
	{
		return this.currentColor;
	}
	
	/**
	 * @param color - sets the current color to color
	 */
	public void setCurrentColor(Color color)
	{
		this.currentColor = color;
	}
	

}
