import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

/**
 * Tool button allows the user to pick a tool.
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class ToolButton extends JButton implements ActionListener {
	
	private String toolType;
	private Class toolClass;
	private CanvasPanel canvas;

	
	/**
	 * Makes a tool button
	 *
	 * @param toolType
	 */
	public ToolButton(String toolType) {
		super(toolType);
		this.toolType = toolType;
		this.addActionListener(this);
	}

	public void actionPerformed(ActionEvent e) {
			try {
				this.toolClass = Class.forName(this.toolType);
				this.canvas.setTool(this.toolClass);
			} catch (ClassNotFoundException exception) {
				exception.printStackTrace();
			}
	}

	/**
	 * Sets the canvas in te paint frame.
	 *
	 * @param canvas
	 */
	public void setCanvas(CanvasPanel canvas){
		this.canvas = canvas;
	}
	
}
