import java.awt.Color;
import java.io.File;


/**
 * the eyedropper selects an areas color for you to be able to use later on
 * they are deselected
 *
 * @author Ian Roberts.
 *         Created Apr 11, 2008.
 */
public class EyeDropperTool extends Brush {

	/**
	 * creates the eyedropper tool
	 *
	 */
	public EyeDropperTool(){
		super(20,new File("eyedropper.bmp"),"eye dropper");
	}
	
	@Override
	public void Paint(Canvas c, int x, int y){
		try{
			Color color = new Color(c.getImage().getRGB(x,y));
			c.getPaint().cc.setColor(color);
		}
		catch(ArrayIndexOutOfBoundsException e){
			//
		}
	}
}
