import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JPanel;


/**
 * This class is a subclass of JPanel
 * It is an panel with buttons for options of brush.
 *
 * @author baekj.
 *         Created Apr 14, 2008.
 */
public class SubFunctionPanel extends JPanel{
	private DrawingPanel bla;
	/**
	 * This constructor creates a Panel where it has the SubFunction buttons
	 * where it enables the users to choose the size and kind of brush they 
	 * want to use.
	 * 
	 * @param bla the instance of the panel for drawing. This is brought into 
	 * this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 */
	public SubFunctionPanel(DrawingPanel bla) {
		super();
		this.bla = bla;
		this.setBackground(Color.GRAY);
		this.setPreferredSize(new Dimension(200,100));
		this.setVisible(true);
		
		this.setLayout(new GridLayout(4,3));
		
		SubFunctionClass f1 = new SubFunctionClass("small point",this.bla,0);
		SubFunctionClass f2 = new SubFunctionClass("medium point",this.bla,1);
		SubFunctionClass f3 = new SubFunctionClass("big point",this.bla,2);
		SubFunctionClass f4 = new SubFunctionClass("small square",this.bla,3);
		SubFunctionClass f5 = new SubFunctionClass("medium sqaure",this.bla,4);
		SubFunctionClass f6 = new SubFunctionClass("big square",this.bla,5);
		SubFunctionClass f7 = new SubFunctionClass("small right",this.bla,6);
		SubFunctionClass f8 = new SubFunctionClass("medium right",this.bla,7);
		SubFunctionClass f9 = new SubFunctionClass("big right",this.bla,8);
		SubFunctionClass f10 = new SubFunctionClass("small left",this.bla,9);
		SubFunctionClass f11 = new SubFunctionClass("medium left",this.bla,10);
		SubFunctionClass f12 = new SubFunctionClass("big left",this.bla,11);
		
		this.add(f1);
		this.add(f2);
		this.add(f3);
		this.add(f4);
		this.add(f5);
		this.add(f6);
		this.add(f7);
		this.add(f8);
		this.add(f9);
		this.add(f10);
		this.add(f11);
		this.add(f12);
		
		
		
	}
}
