import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;


/**
 * This class implements a tool that lets the user draw rectangles in the GUI and it shows a preview of the shape until you click to draw*
 * @author Bryan Warner
 *         Created Apr 10, 2008.
 */
public class RectangleFillTool extends Tool{
	public RectangleFillTool(){
		super(20,new File("rectanglefill.bmp"),"filled rectangle");			
	}
		
		
	public void finish(){
		this.x=-1;
		this.y=-1;
		Graphics2D g  = c.getImage().createGraphics();
		g.setColor(c.getPaint().cc.getColor());
		g.fill(c.getShape());
		c.setShape(null);
		c.repaint();
	}
	@Override
	public void Paint(Canvas c, int x, int y){
		if(this.x != -1 && this.y != -1){
			Rectangle2D.Double r = new Rectangle2D.Double(this.x,this.y,x-this.x,y-this.y);
			c.setShape(r);
		}
		else{
		this.c = c;
		this.x = x;
		this.y = y;
		}
	}

}