import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JComponent;

/**
 * An abstract class defining the various MouseListener and MouseMotionListener
 * methods, as well as a drawTool method that will be used by all Tools to draw
 * themselves.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 10, 2008.
 */
public abstract class Tool extends JComponent implements MouseListener,
		MouseMotionListener {

	/** The area in which the tool draws. */
	protected DrawableArea drawArea;

	/**
	 * Draws the object on the parent component using the provided Graphics
	 * object.
	 * 
	 * @param g
	 *            The Graphics object from the parent component.
	 */
	public void drawTool(Graphics g) {
		super.paintComponent(g);
	}

	public void mouseClicked(MouseEvent e) {
		// Do Nothing

	}

	public void mouseEntered(MouseEvent e) {
		// Do Nothing

	}

	public void mouseExited(MouseEvent e) {
		// Do Nothing

	}

	public void mousePressed(MouseEvent e) {
		// Do Nothing

	}

	public void mouseReleased(MouseEvent e) {
		// Do Nothing

	}

	public void mouseDragged(MouseEvent e) {
		// Do Nothing

	}

	public void mouseMoved(MouseEvent e) {
		// Do Nothing

	}

}
