import java.awt.Dimension;
import java.util.ArrayList;

import javax.swing.JPanel;

/**
 * Creates a panel that cointains the tools available to the user.
 * 
 * @author swansom1. Created Apr 8, 2008.
 */
public class ToolButtonPanel extends JPanel {

	/**
	 * List of tools.
	 */
	private static final String[] TOOLS = { "Pencil", "Brush", "Line", "Rectangle", "Oval", "Polygon", "SprayCan", "Eraser", "Eyedrop" };
	/**
	 * List of buttons.
	 */
	public ArrayList<ToolButton> buttons = new ArrayList<ToolButton>();
	private CanvasPanel canvas;
	private ToolButton tempToolButton;
	private Dimension buttonSize = new Dimension(100,25);

	/**
	 * Creates ToolButtonPanel
	 * 
	 */
	ToolButtonPanel() {
		super();
		this.setPreferredSize(new Dimension(100, 300));
		for (int i=0; i<TOOLS.length;i++) {
			this.tempToolButton = new ToolButton(TOOLS[i]);
			this.tempToolButton.setPreferredSize(this.buttonSize);
			this.add(this.tempToolButton);
			this.buttons.add(this.tempToolButton);
		}
		
	}

	/**
	 * Sets canvas for all tool buttons.
	 * 
	 * @param canvas
	 */
	public void setCanvas(CanvasPanel canvas) {
		this.canvas = canvas;
		for(int i = 0; i < this.buttons.size(); i++){
			this.buttons.get(i).setCanvas(this.canvas);
		}

	}
	

}
