import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.JButton;


/**
 * button with the color
 *
 * @author Joe Wanstrath.
 *         Created Mar 27, 2008.
 */
public class Colors extends JButton{
	private boolean active = false;

	/**
	 * 
	 * takes the name, and rgb values and gives the new color a name
	 *
	 * @param colorName
	 * @param r
	 * @param g
	 * @param b
	 */
	public Colors(String colorName, int r, int g, int b){
		this.setText(colorName);
		Color color = new Color(r,g,b);
		this.setBackground(color);
	}
	
	/**
	 * 
	 * set the active status of this button to b
	 *
	 * @param b status to be set
	 */
	public void setActive(boolean b){
		this.active = b;
	}
	
	/**
	 * 
	 * access the active status of this button
	 *
	 * @return this.active
	 */
	public boolean isActive(){
		return this.active;
	}

	/**
	 * 
	 * action listener for this button
	 *
	 * @param e
	 */
	public void actionPerformed(ActionEvent e){
		e.getSource();
		this.setActive(true);
	}
	
}
