import java.awt.Color;

import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * TODO Put here a description of what this class does.
 *
 * @author Bryce Borchers.
 *         Created Apr 10, 2008.
 */
public class SliderPanel extends JPanel implements ChangeListener{
	
	/**
	 * Initializes our brush stroke size to 10.
	 */
	protected static int stroke = 10;
	
	/**
	 * Initializes the red RGB color value to zero, for black.
	 */
	protected static int redVal = 0;
	
	/**
	 * Initializes the blue RGB color value to zero, for black.
	 */
	protected static int blueVal = 0;
	
	/**
	 * Initializes the green RGB color value to zero, for black.
	 */
	protected static int greenVal = 0;
	
	/**
	 * Creates a slider that changes the tool size.
	 */
	protected static JSlider sliderToolSize;
	
	/**
	 * Creates a slider to change the red RGB value.
	 */
	protected static JSlider sliderRed;
	
	/**
	 * Creates a slider to change the blue RGB value.
	 */
	protected static JSlider sliderBlue;
	
	/**
	 * Creates a slider to change the green RGB value.
	 */
	protected static JSlider sliderGreen;

	/**
	 * Creates the panel of all four sliders.
	 *
	 */
	public SliderPanel() {
		
		// Creates the Stroke size slider
		sliderToolSize = new JSlider();
		sliderToolSize.setMaximum(15);
		sliderToolSize.setMinimum(5);
		sliderToolSize.setMajorTickSpacing(1);
		sliderToolSize.setPaintTicks(true);
		sliderToolSize.setSnapToTicks(true);
		sliderToolSize.setValue(10);
		sliderToolSize.addChangeListener(this);
		sliderToolSize.addChangeListener(Paint.preview);
		this.add(sliderToolSize);
		
		// Creates the red slider
		sliderRed = new JSlider();
		sliderRed.setMaximum(255);
		sliderRed.setMinimum(0);
		sliderRed.setMajorTickSpacing(16);
		sliderRed.setPaintTicks(true);
		sliderRed.setSnapToTicks(true);
		sliderRed.setValue(0);
		sliderRed.addChangeListener(this);
		sliderRed.addChangeListener(Paint.preview);
		this.add(sliderRed);
		
		// Creates the green slider
		sliderGreen = new JSlider();
		sliderGreen.setMaximum(255);
		sliderGreen.setMinimum(0);
		sliderGreen.setMajorTickSpacing(16);
		sliderGreen.setPaintTicks(true);
		sliderGreen.setSnapToTicks(true);
		sliderGreen.setValue(0);
		sliderGreen.addChangeListener(this);
		sliderGreen.addChangeListener(Paint.preview);
		this.add(sliderGreen);
		
		// Creates the blue slider
		sliderBlue = new JSlider();
		sliderBlue.setMaximum(255);
		sliderBlue.setMinimum(0);
		sliderBlue.setMajorTickSpacing(16);
		sliderBlue.setPaintTicks(true);
		sliderBlue.setSnapToTicks(true);
		sliderBlue.setValue(0);
		sliderBlue.addChangeListener(this);
		sliderBlue.addChangeListener(Paint.preview);
		this.add(sliderBlue);
		
		
	}

	public void stateChanged(ChangeEvent e) {
			stroke = sliderToolSize.getValue();
			redVal = sliderRed.getValue();
			greenVal = sliderGreen.getValue();
			blueVal = sliderBlue.getValue();
			ColorTool.drawColor = new Color(redVal, greenVal, blueVal);
	}
}
