import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * Paint
 *
 * @author <Kyle Harris & L. Preston Sego III>.
 *         Started work <March 27, 2008>
 */
public class Paint  extends JFrame implements ActionListener, KeyListener {
	private static final int CANVAS_HEIGHT = 500;
	private static final int CANVAS_WIDTH = 500;
	private static final int TOOLS_HEIGHT = 500;
	private static final int TOOLS_WIDTH = 100;
	/**
	 * Variable Height of Canvas
	 */
	public int height = CANVAS_HEIGHT;
	/**
	 * Variable Width of Canvas
	 */
	public int width = CANVAS_WIDTH;
	private JTextField jWidth;
	private JTextField jHeight;
	private JTextField jFileName;

	/**
	 * Start here.
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		Paint welcomeWindow = new Paint();
		welcomeWindow.setPreferredSize(new Dimension(300,160));
		welcomeWindow.setTitle("Create new cavas");
		
		welcomeWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		welcomeWindow.pack();
		welcomeWindow.setResizable(false);
		welcomeWindow.setLocation(new Point(
				Toolkit.getDefaultToolkit().getScreenSize().width/2 - 150,
				Toolkit.getDefaultToolkit().getScreenSize().height/2 - 50));
		welcomeWindow.setVisible(true);

		
	}
	
	/**
	 * Constructor
	 *
	 */
	public Paint(){
		//Beginning Window where we get our sizes and stuff
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
			JPanel multi = new JPanel();
			multi.setLayout(new GridLayout(4,2));
			multi.add(new JLabel("   File Name:"));
			this.jFileName = new JTextField("Untitled");
			multi.add(this.jFileName);
			
			multi.add(new JLabel("   Width:"));
			this.jWidth = new JTextField("500");
			multi.add(this.jWidth);
	
			
			multi.add(new JLabel("   Height:"));
			this.jHeight = new JTextField("500");
			multi.add(this.jHeight);
				
		panel.add(multi, BorderLayout.NORTH);
		
		JButton button = new JButton("Create");
		button.setSize(new Dimension(50,20));
		button.addActionListener(this);
		button.addKeyListener(this);
		
		panel.add(button, BorderLayout.EAST);
		this.add(panel);
		
	}
	
	/**
	 * Create Environment
	 *
	 */
	public void createWindows(){
		//Create the Actual Windows
		
		//Create the Canvas
		JFrame canvas = new JFrame();
		String fileName = this.jFileName.getText();
		canvas.setSize(this.width, this.height);
		canvas.setTitle("Paint Canvas - " + fileName);
		canvas.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width/2 - this.width/2,
				Toolkit.getDefaultToolkit().getScreenSize().height/2 - this.height/2);
		canvas.setBackground(new Color(255, 255, 255));
		canvas.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		
		//Create the Tools Pallette
		JFrame tools = new JFrame();
		tools.setSize(TOOLS_WIDTH, TOOLS_HEIGHT);
		tools.setTitle("Tools Pallette");
		tools.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		tools.setResizable(false);
		
		//create the Components
		final CanvasComponent canvasComponent = new CanvasComponent();
		ToolsComponent toolsComponent = new ToolsComponent(canvasComponent);
		
		//Create the Color Panel thing
		JFrame colors = new JFrame();
		JColorChooser colorChooser = new JColorChooser();
		colors.add(colorChooser);
		colors.setSize(450,300);
		colors.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width-450, 0);
		colors.setVisible(true);
		ColorSelectionModel model = colorChooser.getSelectionModel();
		colors.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		//This is kind of a mini sub class thing
		model.addChangeListener( new ChangeListener(){

			public void stateChanged(ChangeEvent e) {
				ColorSelectionModel model = ( ColorSelectionModel )e.getSource();
                // Get the new color value
                Color chosenColor = model.getSelectedColor();
				canvasComponent.changeChosenColor(chosenColor);	

			}
		});
		
		
		//Add the Components 
		canvas.add(canvasComponent);
		tools.add(toolsComponent);
		
		
		//Do the final things
		canvas.setResizable(false);
		tools.setResizable(false);
		canvas.setVisible(true);
		tools.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {
		this.setVisible(false);
		this.height = Integer.valueOf(this.jHeight.getText()).intValue();
		this.width = Integer.valueOf(this.jWidth.getText()).intValue();	
		createWindows();
	}

	
	public void keyPressed(KeyEvent e) {
		if (e.VK_ENTER == e.VK_ENTER){
			this.setVisible(false);
			this.height = Integer.valueOf(this.jHeight.getText()).intValue();
			this.width = Integer.valueOf(this.jWidth.getText()).intValue();	
			createWindows();
		}

		
	}

	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void keyTyped(KeyEvent e) {
		// TODO Auto-generated method stub.
		
	}
}
