import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;

/**
 * Creates a tool that behaves like a spray paint can. Must constantly drag
 * mouse to function.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 14, 2008.
 */
public class SprayPaintTool extends Tool {

	private ArrayList<Ellipse2D.Double> sprayList = new ArrayList<Ellipse2D.Double>();

	private Color color;

	/**
	 * Creates the spray paint tool with access to the given drawing area.
	 * 
	 * @param drawArea
	 *            The DrawableArea the tool has access to.
	 */
	public SprayPaintTool(DrawableArea drawArea) {
		this.drawArea = drawArea;
	}

	@Override
	public void mousePressed(MouseEvent e) {
		this.color = this.drawArea.getOutlineColor();
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		double rad = 0.5 + Math.random() * 3;
		double randSpotX = Math.random() * 6.5;
		double randSpotY = Math.random() * 6.5;
		if (Math.random() > 0.5) {
			randSpotX *= -1;
		}
		if (Math.random() > 0.5) {
			randSpotY *= -1;
		}
		Ellipse2D.Double newDot = new Ellipse2D.Double(x + randSpotX, y
				+ randSpotY, rad * 2, rad * 2);
		this.sprayList.add(newDot);
		this.getParent().repaint();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		this.repaint();
		this.drawArea.disableLastTool();
		this.drawArea.addTool(new SprayPaintTool(this.drawArea));
	}

	@Override
	public void drawTool(Graphics g) {
		super.drawTool(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setColor(this.color);
		for (int i = 0; i < this.sprayList.size(); i++) {
			g2.fill(this.sprayList.get(i));
		}
	}
}
