import java.awt.Color;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

/**
 * The toolbar that holds the various color buttons.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 4, 2008.
 */
public class PalleteBar extends JToolBar {

	private JButton outlineColor, fillColor;

	/**
	 * Constructs the toolbar and adds the color buttons.
	 * 
	 * @param drawArea
	 *            The drawing area the buttons will affect.
	 * 
	 */
	public PalleteBar(DrawableArea drawArea) {
		super(SwingConstants.HORIZONTAL);
		this.setFloatable(false);
		addColorButtons(this, drawArea);

		JLabel spacer = new JLabel("                               ");
		this.add(spacer);
		// Add buttons that will display current outline and fill colors.
		this.outlineColor = new JButton("     ");
		this.outlineColor.setBackground(drawArea.getOutlineColor());
		this.outlineColor.setEnabled(false);
		this.add(this.outlineColor);
		this.fillColor = new JButton("     ");
		this.fillColor.setBackground(drawArea.getFillColor());
		this.fillColor.setEnabled(false);
		this.add(this.fillColor);
	}

	private void addColorButtons(PalleteBar bar, DrawableArea drawArea) {
		// Adds the buttons to the tool bar.
		Color[] colors = { Color.black, Color.blue, Color.cyan, Color.darkGray,
				Color.gray, Color.green, Color.lightGray, Color.magenta,
				Color.orange, Color.pink, Color.red, Color.white, Color.yellow,
				null };
		for (Color color : colors) {
			ColorButton button = new ColorButton(color, drawArea, this);
			bar.add(button);
		}
	}

	/**
	 * Sets the background color of the button that displays the outline color.
	 * 
	 * @param color
	 *            The color to set.
	 */
	public void setOutlineColor(Color color) {
		this.outlineColor.setBackground(color);
	}

	/**
	 * Sets the background color of the button that displays the fill color.
	 * 
	 * @param color
	 *            The color to set.
	 */
	public void setFillColor(Color color) {
		this.fillColor.setBackground(color);
	}
}
