import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;


/**
 * ToolBar panel that controls tool selection.
 *
 * @author Jacob Wise & Eric Schulte
 *         Created Apr 11, 2008.
 */
public class ToolBar extends JPanel implements ActionListener{
	
	/**	  variable to keep track of current tool	 */
	public int operation = 0;
	
	/**
	 * Creates the tool bar panel where the user can choose their painting tool
	 */
	public ToolBar(){
		
		/* Sets the panel layout */
		this.setLayout(new GridLayout(10,1));
		
		/* Creates the JRadioButtons */
		JRadioButton pencil = new JRadioButton("Pencil");
			pencil.setMnemonic(KeyEvent.VK_P);
			pencil.setActionCommand("pencil");
			pencil.setSelected(true);
			pencil.setToolTipText("Alt+P");
	    
		JRadioButton line = new JRadioButton("Line");
			line.setMnemonic(KeyEvent.VK_L);
			line.setActionCommand("line");
			line.setSelected(false);
			line.setToolTipText("Alt+L");
		
		JRadioButton paintBrush = new JRadioButton("Paint Brush");
			paintBrush.setMnemonic(KeyEvent.VK_B);
			paintBrush.setActionCommand("paintBrush");
			paintBrush.setSelected(false);
			paintBrush.setToolTipText("Alt+B");
			
		JRadioButton rectangle = new JRadioButton("Rectangle");
			rectangle.setMnemonic(KeyEvent.VK_R);
			rectangle.setActionCommand("rectangle");
			rectangle.setSelected(false);
			rectangle.setToolTipText("Alt+R");
		
		JRadioButton oval = new JRadioButton("Oval");
			oval.setMnemonic(KeyEvent.VK_V);
			oval.setActionCommand("oval");
			oval.setSelected(false);
			oval.setToolTipText("Alt+V");
			
		JRadioButton filledOval = new JRadioButton("Filled Oval");
			filledOval.setMnemonic(KeyEvent.VK_D);
			filledOval.setActionCommand("filledOval");
			filledOval.setSelected(false);
			filledOval.setToolTipText("Alt+D");
		
		JRadioButton filledRectangle = new JRadioButton("Filled Rectangle");
			filledRectangle.setMnemonic(KeyEvent.VK_T);
			filledRectangle.setActionCommand("filledRectangle");
			filledRectangle.setSelected(false);
			filledRectangle.setToolTipText("Alt+T");
	
		JRadioButton polygon = new JRadioButton("Polygon");
			polygon.setMnemonic(KeyEvent.VK_G);
			polygon.setActionCommand("polygon");
			polygon.setSelected(false);
			polygon.setToolTipText("Alt+G");
			
		JRadioButton sprayCan = new JRadioButton("Spray Can");
			sprayCan.setMnemonic(KeyEvent.VK_N);
			sprayCan.setActionCommand("sprayCan");
			sprayCan.setSelected(false);
			sprayCan.setToolTipText("Alt+N");
	
		JRadioButton eraser = new JRadioButton("Eraser");
			eraser.setMnemonic(KeyEvent.VK_E);
			eraser.setActionCommand("eraser");
			eraser.setSelected(false);
			eraser.setToolTipText("Alt+E");
	
		/* adds the buttons to the panel */
		ButtonGroup toolBar = new ButtonGroup();
			toolBar.add(pencil);
			toolBar.add(line);
			toolBar.add(paintBrush);
			toolBar.add(oval);
			toolBar.add(rectangle);
			toolBar.add(polygon);
			toolBar.add(filledOval);
			toolBar.add(filledRectangle);
			toolBar.add(sprayCan);
			toolBar.add(eraser);
			
		/* adds the action listeners */	
		pencil.addActionListener(this);
		line.addActionListener(this);
		paintBrush.addActionListener(this);
		oval.addActionListener(this);
		rectangle.addActionListener(this);
		polygon.addActionListener(this);
		filledOval.addActionListener(this);
		filledRectangle.addActionListener(this);
		sprayCan.addActionListener(this);
		eraser.addActionListener(this);
		
		/* adds buttons to the toolbar */
		this.add(pencil);
		this.add(paintBrush);
		this.add(line);
		this.add(polygon);
		this.add(oval);
		this.add(filledOval);
		this.add(rectangle);
		this.add(filledRectangle);
		this.add(sprayCan);
		this.add(eraser);
	}
	
	public void actionPerformed(ActionEvent e) {
	
	/* Determines what action has occured */

		if (e.getActionCommand() == "pencil") {
			this.operation = 0;
			System.out.println("Selected pencil");
		}

		if (e.getActionCommand() == "line") {
			this.operation = 1;
			System.out.println("Selected line tool"); 
		}

		if (e.getActionCommand() == "paintBrush") {
			this.operation = 2;
			System.out.println("Selected paint brush");
		}

		if (e.getActionCommand() == "rectangle") {
			this.operation = 3;
			System.out.println("Selected rectangle");
		}

		if (e.getActionCommand() == "filledRectangle") {
			this.operation = 4;
			System.out.println("Selected filled rectangle");
		}

		if (e.getActionCommand() == "oval") {
			this.operation = 5;
			System.out.println("Selected oval");
		}

		if (e.getActionCommand() == "filledOval") {
			this.operation = 6;
			System.out.println("Selected filled oval");
		}

		if (e.getActionCommand() == "polygon") {
			this.operation = 7;
			System.out.println("Selected polygon");
		}
		
		if (e.getActionCommand() == "sprayCan") {
			this.operation = 8;
			System.out.println("Selected spray can");
		}
		
		if (e.getActionCommand() == "eraser") {
			this.operation = 9;
			System.out.println("Selected eraser");
		}
	}
	
	/**
	 * Helper method for outside class access.
	 *
	 * @return this.operation
	 */
	public int getOperation() {
		return(this.operation);
	}
}
