import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/**
 * PaintMenu is a JMenuBar that is added to the frame in Paint
 * 
 * @author Jacob Wise & Eric Schulte. Created Mar 25, 2008.
 */
public class PaintMenu extends JMenuBar implements ActionListener {
	/**
	 * Creates the Menu Bar that is set in the frame
	 * 
	 */
	private PaintCanvas paintCanvas;

	private Paint paint;

	private JFileChooser fileDialog;

	private File editFile;

	private File file;

	private String title;

	/**
	 * 
	 * 
	 * @param p
	 *            new Paint Canvas
	 * @param t
	 *            new Paint
	 */
	public PaintMenu(PaintCanvas p, Paint t) {

		this.paintCanvas = p;
		this.paint = t;

		// creates the file menu
		JMenu fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
		this.add(fileMenu);

		// adds the New button to the file menu
		JMenuItem newItem = new JMenuItem("New          Alt+F+N");
		newItem.setMnemonic(KeyEvent.VK_N);
		fileMenu.add(newItem);
		newItem.addActionListener(this);
		newItem.setActionCommand("new");

		// adds the Open button to the file menu
		JMenuItem openItem = new JMenuItem("Open        Alt+F+O");
		openItem.setMnemonic(KeyEvent.VK_O);
		fileMenu.add(openItem);
		openItem.addActionListener(this);
		openItem.setActionCommand("open");

		// adds the Save button to the file menu
		JMenuItem saveItem = new JMenuItem("Save         Alt+F+S");
		saveItem.setMnemonic(KeyEvent.VK_S);
		fileMenu.add(saveItem);
		saveItem.addActionListener(this);
		saveItem.setActionCommand("save");

		// adds the Exit button to the file menu
		JMenuItem exitItem = new JMenuItem("Exit         Alt+F+E");
		saveItem.setMnemonic(KeyEvent.VK_S);
		fileMenu.add(exitItem);
		exitItem.addActionListener(this);
		exitItem.setActionCommand("exit");

		// creates the edit menu
		JMenu editMenu = new JMenu("Edit");
		editMenu.setMnemonic(KeyEvent.VK_D);
		this.add(editMenu);

		// adds the Clear Screen button to the edit menu
		JMenuItem clearItem = new JMenuItem("Clear Screen      Alt+F+C");
		clearItem.setMnemonic(KeyEvent.VK_C);
		editMenu.add(clearItem);
		clearItem.addActionListener(this);
		clearItem.setActionCommand("clear");

		// adds the Fill Background to the edit menu
		JMenuItem fillItem = new JMenuItem("Fill Background     Alt+F+H");
		fillItem.setMnemonic(KeyEvent.VK_H);
		editMenu.add(fillItem);
		fillItem.addActionListener(this);
		fillItem.setActionCommand("fill");
	}

	public void actionPerformed(ActionEvent e) {

		// Performs new action
		if (e.getActionCommand() == "new") {
			this.paintCanvas.clearScreen();
			this.paint.setTitle("S&W Paint Inc: Untitled");
		}
		// Performs save action
		else if (e.getActionCommand() == "save") {

			try {
				save();
			} catch (AWTException exception) {
				// catch exceptions
				exception.printStackTrace();
			} catch (IOException exception) {
				// catch exceptions
				exception.printStackTrace();
			}
			this.paint.setTitle(this.title);
		}
		// Performs exit action
		else if (e.getActionCommand() == "exit") {
			System.exit(0);
		}
		// Performs open action
		else if (e.getActionCommand() == "open") {
			open();
		}
		// Performs clear action
		else if (e.getActionCommand() == "clear") {
			this.paintCanvas.clearScreen();
		}
		// performs fill action
		else if (e.getActionCommand() == "fill") {
			this.paintCanvas.fillBackground();
		}

	}

	/**
	 * Saves the Paint Canvas as a jpeg
	 * 
	 * @throws AWTException
	 * @throws IOException
	 */
	public void save() throws AWTException, IOException {
		BufferedImage screencapture = new Robot()
				.createScreenCapture(new Rectangle(this.paintCanvas
						.screenSize()));

		this.editFile = null;
		if (this.fileDialog == null) {
			this.fileDialog = new JFileChooser();
		}

		if (this.editFile == null) {
			this.file = new File("screencapture.jpg");
		} else {
			this.file = new File(this.editFile.getName());
		}

		this.fileDialog.setSelectedFile(this.file);
		this.fileDialog.setDialogTitle("Select File to be Saved");
		int option = this.fileDialog.showSaveDialog(this);
		if (option != JFileChooser.APPROVE_OPTION) {
			this.title = this.paint.getTitle();
			return ;// User canceled or clicked the dialog's close box.
		}
		this.file = this.fileDialog.getSelectedFile();
		if (this.file.exists()) {// Ask the user whether to replace the file.
			int response = JOptionPane.showConfirmDialog(this, "The file \""
					+ this.file.getName()
					+ "\" already exists.\nDo you want to replace it?",
					"Confirm Save", JOptionPane.YES_NO_OPTION,
					JOptionPane.WARNING_MESSAGE);
			if (response == JOptionPane.NO_OPTION) {
				return; // User does not want to replace the file.
			}
		}
		ImageIO.write(screencapture, "jpg", this.file);
		this.title = "S&W Paint Inc: " + this.file.getName();

	}

	/**
	 * Opens a JFileChooser but doesnt actually open a file yet
	 * 
	 */
	@SuppressWarnings("unused")
	public void open() {
		if (this.fileDialog == null)
			this.fileDialog = new JFileChooser();
		this.fileDialog.setDialogTitle("Select File to be Opened");
		this.fileDialog.setSelectedFile(null); // No file is initially
												// selected.
		int option = this.fileDialog.showOpenDialog(this);
		if (option != JFileChooser.APPROVE_OPTION)
			return; // User canceled or clicked the dialog's close box.
		File selectedFile = this.fileDialog.getSelectedFile();

	}

}