import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;

/**
 * A button for the different tools.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 4, 2008.
 */
public class ToolButton extends JButton implements ActionListener {

	private DrawableArea drawArea;

	private String tool;

	/**
	 * Creates a tool button
	 * 
	 * @param tool
	 *            The tool.
	 * @param drawArea
	 *            The DrawableArea in which the user will draw.
	 */
	public ToolButton(String tool, DrawableArea drawArea) {
		super();
		java.net.URL imgURL = this.getClass().getResource(
				"images/" + tool + ".gif");
		ImageIcon pic = new ImageIcon(imgURL);
		this.setIcon(pic);
		this.setToolTipText(tool);
		this.drawArea = drawArea;
		this.tool = tool;
		this.addActionListener(this);
	}

	public void actionPerformed(ActionEvent e) {
		this.drawArea.removeLastTool();
		if (this.tool.equals("Pencil")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new PencilTool(this.drawArea));
		} else if (this.tool.equals("Brush")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new BrushTool(this.drawArea));
		} else if (this.tool.equals("Rectangle")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new RectangleTool(this.drawArea));
		} else if (this.tool.equals("Oval")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new OvalTool(this.drawArea));
		} else if (this.tool.equals("Polygon")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new PolygonTool(this.drawArea));
		} else if (this.tool.equals("Line")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new LineTool(this.drawArea));
		} else if (this.tool.equals("Eraser")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new EraserTool(this.drawArea));
		} else if (this.tool.equals("Spray Paint")) {
			this.drawArea.disableLastTool();
			this.drawArea.addTool(new SprayPaintTool(this.drawArea));
		}
	}

}
