import java.awt.GridLayout;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;


/**
 * @author Jon Klein, CM2296
 * Class creates a panel with a grid layout, filled with paintbuttons.
 */
public abstract class ButtonPanel extends JPanel
{
	protected ArrayList <PaintButton> Buttons = new ArrayList<PaintButton>();
	private PaintButton selected = null;
	/**
	 * @param gridLayout The grid layout, needs to be passed.
	 * @param buttons The number of buttons desired on the panel.
	 */
	public ButtonPanel(GridLayout gridLayout, int buttons)
	{
		super(gridLayout);
		for (int i = 0; i < buttons; i++)
		{
			this.Buttons.add(new PaintButton("", i));
		}
		this.selected = this.Buttons.get(0);
		
		for (PaintButton button : this.Buttons)
		{
			this.add(button);
			button.setBorder(new SoftBevelBorder(BevelBorder.RAISED));
			button.setPanel(this);
			button.addActionListener(button);
		}
		
	}
	
	/**
	 * Returns the selected button on a panel.
	 * @return The currently selected button on the panel.
	 */
	public PaintButton getSelected()
	{
		return this.selected;
	}
	
	/**
	 * Sets the selected PaintButton.
	 * @param selected the button to 'select'
	 */
	public void setSelected(PaintButton selected)
	{
		this.selected = selected;
		
	}
	
	


}
