import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;


/**
 * A button that listens for a click and stores a color
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 13, 2008.
 */
public class ColorButton extends JButton implements ActionListener {

	private ColorPanel colorPanel;
	private Color color;

	/**
	 * creates a new ColorButton
	 *
	 * @param colorPanel - the ColorPanel to change the current color in the Color Panel
	 * @param color - the color of the Button
	 */
	public ColorButton(ColorPanel colorPanel, Color color)
	{
		this.colorPanel = colorPanel;
		this.color = color;
	}

	public void actionPerformed(ActionEvent e) {
		this.colorPanel.setCurrentColor(this.color);
	}

}
