import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;


/**
 * Creates the entire menu bar at the top of the Paint window.
 *
 * @author Annmarie Stanley.
 *         Created Apr 13, 2008.
 */
public class Menu extends JMenuBar implements ActionListener {

	private JMenuItem menuItem;
	private CanvasPanel cpan;
	private JMenuItem newM, open, save, exit, help;
	
	
	/** Creates the menu bar
	 * @param c 
	 * @param frame */
	public Menu(CanvasPanel c) {
		//this.menuBar = new JMenuBar();
		
		JMenu fileMenu = new JMenu("File");
		this.newM = new JMenuItem("New");
		this.newM.setName("New");
		this.newM.setActionCommand("new");
		this.newM.addActionListener(this);
		fileMenu.add(this.newM);
		fileMenu.addSeparator();
		
		this.open = new JMenuItem("Open");
		this.open.setName("Open");
		this.open.setActionCommand("open");
		this.open.addActionListener(this);
		fileMenu.add(this.open);
		fileMenu.addSeparator();
		
		this.save = new JMenuItem("Save");
		this.save.setName("Save");
		this.save.setActionCommand("save");
		this.save.addActionListener(this);
		fileMenu.add(this.save);
		fileMenu.addSeparator();
		
		this.exit = new JMenuItem("Exit");
		this.exit.setName("Exit");
		this.exit.setActionCommand("exit");
		this.exit.addActionListener(this);
		fileMenu.add(this.exit);
		
		this.add(fileMenu);
		
		JMenu editMenu = new JMenu("Edit");
		this.menuItem = new JMenuItem("Undo");
		this.menuItem.addActionListener(this);
		editMenu.add(this.menuItem);
		
		JMenu viewMenu = new JMenu("View");
		JMenu imageMenu = new JMenu("Image");
		JMenu helpMenu = new JMenu("Help");
		this.help = new JMenuItem("Help");
		this.help.setActionCommand("help");
		this.help.addActionListener(this);
		helpMenu.add(this.help);
		
		this.add(viewMenu);
		this.add(imageMenu);
		this.add(helpMenu);
		
		this.cpan = c;
		
	}

	public void actionPerformed(ActionEvent e) {
		if ("new".equals(e.getActionCommand())) {
			this.cpan.shapeList = new ArrayList<ShapeInfo>();
		}
		if ("open".equals(e.getActionCommand())) {
			JOptionPane.showMessageDialog(null,  
					 "Sorry, this has not been implemented yet.", 
					 "Notice", JOptionPane.INFORMATION_MESSAGE);
		}
		if ("save".equals(e.getActionCommand())) {
			JOptionPane.showMessageDialog(null,  
					 "Sorry, this has not been implemented yet.", 
					 "Notice", JOptionPane.INFORMATION_MESSAGE);
		}
		if ("exit".equals(e.getActionCommand())) {
			System.exit(0);
		}
		if ("help".equals(e.getActionCommand())) {
			 JOptionPane.showMessageDialog(null,  
					 "This program is definitely a work in progress. " +
					 "If some things don't work, no worries. It was " +
					 "intentional. Hope you enjoy painting with our awesome " +
					 "program!", "Help", JOptionPane.INFORMATION_MESSAGE);
		}

		}
		
	}
	

