import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;


/**
 * Allows us to select various drawing tools.
 *
 * @author Bryce Borchers.
 *         Created Mar 28, 2008.
 */
public class DrawTool extends JButton implements ActionListener {
	
	/**
	 * Initializes our drawing tool to Undo to ensure no initial drawing.
	 */
	protected static String drawTool = "Undo";
	
	/**
	 * Allows us to click tool buttons and use those tools.
	 *
	 * @param s
	 */
	public DrawTool(String s) {
		super(s);
		this.addActionListener(this);
		this.addActionListener(Paint.preview);
	}

	public void actionPerformed(ActionEvent e) {
		DrawTool.drawTool = this.getText();
		DrawArea.polyCount = 0;
	}

}
