import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

/**
 * A tool that allows the user to "erase" items on the screen.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 12, 2008.
 */
public class EraserTool extends BrushTool {

	/**
	 * Constructs an eraser tool with the given DrawableArea.
	 * 
	 * @param drawArea
	 *            The DrawableArea of the tool.
	 */
	public EraserTool(DrawableArea drawArea) {
		super(drawArea);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		this.drawArea.repaint();
		this.drawArea.disableLastTool();
		this.drawArea.addTool(new EraserTool(this.drawArea));
	}

	@Override
	public void drawTool(Graphics g) {
		this.color = Color.white;
		super.drawTool(g);
	}

}
