import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JPanel;


/**
 * This creates a color panel of a static amount of colors.
 *
 * @author Jared Mathis.
 *         Created Apr 13, 2008.
 */
public class ColorPanel extends JPanel implements MouseListener{
	
	// Constants
	private static final Color[] DEFAULT_COLOR_PALETTE = {
		Color.BLACK,
		Color.DARK_GRAY,
		Color.GRAY,
		Color.LIGHT_GRAY,
		Color.WHITE,
		Color.PINK,
		Color.RED,
		Color.ORANGE,
		Color.YELLOW,
		Color.GREEN,
		Color.CYAN,
		Color.BLUE,
		Color.MAGENTA,
		};

	/**
	 * Number of rows.  Don't  make this number too big or funny things will happen.
	 */
	protected static final int ROWS = 1;
	/**
	 * Number of columns.  Calculated from number of rows.
	 */
	protected static final int COLS = DEFAULT_COLOR_PALETTE.length/ROWS;
	/**
	 * Spacing between each color.
	 */
	protected static final int SPACING = 5;
	
	
	
	// Instance Fields
	private ArrayList<ColorSwatch> palette;
	
	/**
	 * Paint object.
	 */
	protected Paint paint;
	
	
	
	
	/**
	 * Constructs a ColorPanel.  A ColorPanel holds ColorSwatches.
	 *
	 * @param painter Paint object this ColorPanel is in.
	 */
	public ColorPanel(Paint painter){
		super();
		
		this.paint = painter;
		this.palette = new ArrayList<ColorSwatch>(0);
		
		for (Color color : DEFAULT_COLOR_PALETTE) {
			this.palette.add(new ColorSwatch(color, this));
		}
		
		GridLayout layout = new GridLayout(ROWS, COLS);
		layout.setHgap(SPACING);
		layout.setVgap(SPACING);
		this.setLayout(layout);
	}

	public void mouseClicked(MouseEvent arg0) { /* empty */ }
	public void mouseReleased(MouseEvent arg0) { /* empty */ }
	public void mouseEntered(MouseEvent arg0) { /* empty */ }
	public void mouseExited(MouseEvent arg0) { /* empty */ }
	
	public void mousePressed(MouseEvent arg0) { 
		this.paint.toolPanel.endCurrentTool();
		
		if(arg0.getButton()==MouseEvent.BUTTON1){
			JButton button = (JButton)arg0.getSource();
			this.paint.primaryColor = button.getBackground();
			super.repaint();
			//System.out.println(painter.primaryColor);
		}
		else if(arg0.getButton()==MouseEvent.BUTTON3){
			JButton button = (JButton)arg0.getSource();
			this.paint.secondaryColor = button.getBackground();
			//System.out.println(painter.secondaryColor);
		}	
	}

}
