import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;


/**
 * This class creates a color chooser JFrame with two buttons: Okay and Cancel.  This is used to change the primaryColor and secondaryColor fields of a Paint object.
 *
 * @author Jared Mathis.
 *         Created Apr 13, 2008.
 */
public class ColorChooser extends JFrame implements MouseListener, ActionListener {
	private static final int 
	PRIMARY_COLOR = 0,
	SECONDARY_COLOR = 1,
	FRAME_WIDTH = 450,
	FRAME_HEIGHT = 410;
	
	
	private JColorChooser jcc;
	private Paint paint;
	private int color;

	/**
	 * Creates a ColorChooser frame.
	 *
	 * @param paint Paint object
	 */
	ColorChooser(Paint paint) {

		this.jcc = new JColorChooser();
		this.paint = paint;
		
		JButton okay = new JButton("Okay");
		okay.addActionListener(this);
		
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(this);
		
		JPanel panel = new JPanel();
		panel.add(this.jcc);		
		panel.add(okay);
		panel.add(cancel);

		this.setContentPane(panel);
		this.setSize(new Dimension(FRAME_WIDTH, FRAME_HEIGHT));
		this.setResizable(false);

	}

	public void mousePressed(MouseEvent e) {
		Color c = null;
		
		Point click = e.getPoint();
		click.move(click.x, click.y - CurrentColor.PADDING);
		
		if (
				click.x > 0 &&
				click.y > 0 &&
				click.x < 2 * CurrentColor.SIZE &&
				click.y < 2 * CurrentColor.SIZE) {
			c = this.paint.primaryColor;
			this.setTitle("Choose Primary Color");
			this.color = PRIMARY_COLOR;
		}
		
		else if (
				(click.x > 2 * CurrentColor.SIZE &&
				click.x < 3 * CurrentColor.SIZE &&
				click.y > CurrentColor.SIZE &&
				click.y < 3 * CurrentColor.SIZE) 
				||
				(click.y > 2 * CurrentColor.SIZE &&
				click.y < 3 * CurrentColor.SIZE &&
				click.x > CurrentColor.SIZE &&
				click.x < 3 * CurrentColor.SIZE)
				) {
			c = this.paint.secondaryColor;
			this.setTitle("Choose Secondary Color");
			this.color = SECONDARY_COLOR;
		}
		
		if (c != null) {
			this.paint.toolPanel.endCurrentTool();
			
			Point location = this.paint.window.getLocation();
			location.move(
					location.x + this.paint.window.getWidth()/2 - this.getWidth()/2,
					location.y + this.paint.window.getHeight()/2 - this.getHeight()/2);
			this.setLocation(location);
		
			this.jcc.setColor(c);
			this.setVisible(true);
		}

	}
	
	public void mouseClicked(MouseEvent e) { /*empty*/ }
	public void mouseEntered(MouseEvent e) { /*empty*/ }
	public void mouseExited(MouseEvent e) { /*empty*/ }
	public void mouseReleased(MouseEvent e) { /*empty*/ }

	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		if (!(source instanceof JButton)) return;
		
		else if (((JButton)source).getText() == "Cancel") this.setVisible(false);
		
		else if (((JButton)source).getText() == "Okay") {
			
			if (this.color == PRIMARY_COLOR) this.paint.primaryColor = this.jcc.getColor();
			else if (this.color == SECONDARY_COLOR) this.paint.secondaryColor = this.jcc.getColor();
			
			this.setVisible(false);
			this.paint.toolPanel.viewer.repaint();
		}
	}

}
