import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

/**
 * Menubar contains menu options File New - create a new canvas Edit Undo - undo
 * the last shape Redo - redo the most recent undo Help - opens a JPanel
 * containing the help text
 * 
 * @author Joe Wanstrath. Created Mar 27, 2008.
 */
public class Menubar extends JMenuBar implements ActionListener {
	private Canvas canvas;

	private JMenu edit;

	private JMenu file;

	private JMenu help;

	private JMenuItem undo;

	private JMenuItem clear;

	private JMenuItem redo;

	private JMenuItem Help;

	private ArrayList<Tool> currentShape = new ArrayList<Tool>();

	/**
	 * 
	 * Create the menubar
	 * 
	 * @param canvas
	 */
	public Menubar(Canvas canvas) {

		this.canvas = canvas;
		this.edit = new JMenu("Edit");
		this.undo = new JMenuItem("Undo");
		this.undo.addActionListener(this);
		this.edit.add(this.undo);
		this.redo = new JMenuItem("Redo");
		this.redo.addActionListener(this);
		this.edit.add(this.redo);

		this.file = new JMenu("File");
		this.clear = new JMenuItem("New");
		this.clear.addActionListener(this);
		this.file.add(this.clear);

		this.help = new JMenu("Help");
		this.Help = new JMenuItem("Help");
		this.help.add(this.Help);
		this.Help.addActionListener(this);

		this.add(this.file);
		this.add(this.edit);
		this.add(this.help);

	}

	/**
	 * Detect an action performed in this panel
	 * 
	 * @param e
	 *            performed action
	 */
	public void actionPerformed(ActionEvent e) {

		if (e.getSource().equals(this.clear)) {
			this.canvas.shapes.clear();
		} else if (e.getSource().equals(this.undo)) {
			if (this.canvas.shapes.size() > 0) {
				int index = this.canvas.shapes.size() - 1;
				this.currentShape.add(this.canvas.shapes.get(index));
				this.canvas.shapes.remove(index);
			}
		} else if (e.getSource().equals(this.redo)) {
			if (this.currentShape.size() > 0) {
				int index2 = this.currentShape.size() - 1;
				this.canvas.shapes.add(this.currentShape.get(index2));
				this.currentShape.remove(index2);
			}
		} else if (e.getSource().equals(this.Help)) {
			JFrame helpFrame = new JFrame();
			helpFrame.setSize(500, 180);
			helpFrame.setTitle("Help");
			JTextComponent label = new JTextArea();
			label
					.setText("The pencil will draw a line along the path of"
							+ "the mouse, the paintbrush does the same\n thing except it is wider,"
							+ " the line draws a straight line from the start point to where you \n"
							+ "release the mouse, the oval draws an oval inside an invisible rectangle "
							+ "with opposite \ncorners where the mouse starts and stops, the rectangle draws"
							+ " a rectangle with opposite\n corners where the mouse starts and stops, the "
							+ "polygon draws a polygon with the number\n of sides with the number of sides "
							+ "specified by the user, the spraycan acts like a \nspraypaint can, text allows "
							+ "the user to type text where you click, and the eraser erases \nthings");
			label.setBounds(0, 0, 500, 500);
			helpFrame.add(label);
			helpFrame.setVisible(true);
		}
		this.canvas.repaint();
	}

}
