import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;


/**
 * This button is displayed in ColorSelectionPanel in order to give the users
 * the choice to pick colors in Paint.
 *
 * @author baekj.
 *         Created Apr 11, 2008.
 */
public class ColorButton extends JButton implements ActionListener{
	private Color other;
	private DrawingPanel bla;
	private JButton button;
	/**
	 * This constructor creates a button and sets its color and size.
	 *
	 * @param message the label of the button
	 * @param other the color of the button
	 * @param drawing the instance of the panel for drawing. This is brought 
	 * into this class so that the changes in made in this class can affect the 
	 * drawing panel. 
	 * @param button the instance of the button where it displays the color
	 * that is currently chosen.
	 */
	public ColorButton(String message, Color other, DrawingPanel drawing, JButton button) {
		super(message);
		this.bla = drawing;
		this.other = other;
		this.setBackground(other);
		this.setSize(30,30);
		this.button = button;
	}

	
	public void actionPerformed(ActionEvent e) {

		this.bla.colorChanger(this.other);
		this.button.setBackground(this.other);

	}
}
