import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 * Creates a GUI that allows the user to draw and create various objects.
 * 
 * @author Joel Carlson and Ty Strayer. Started work 1 Apr 2008
 */
public class Paint extends JFrame {

	private static final int FRAME_HEIGHT = 600;

	private static final int FRAME_WIDTH = 800;

	/**
	 * Constructs the main JFrame of the Paint program and the components which
	 * lie inside.
	 * 
	 */
	public Paint() {
		// Create main JPanel
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());

		// Create draw/work space
		DrawableArea drawArea = new DrawableArea();
		mainPanel.add(drawArea, BorderLayout.CENTER);

		// Create tool bar, call method to add its buttons, and add to window.
		ToolBar toolBar = new ToolBar(drawArea);
		mainPanel.add(toolBar, BorderLayout.WEST);

		// Create pallete bar
		PalleteBar palleteBar = new PalleteBar(drawArea);
		mainPanel.add(palleteBar, BorderLayout.SOUTH);

		// Create menu bar
		JMenuBar menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("File");
		JMenuItem saveItem = new JMenuItem("Save");
		JMenuItem saveAsItem = new JMenuItem("SaveAs");
		JMenuItem newItem = new JMenuItem("New");
		JMenuItem openItem = new JMenuItem("Open");
		saveItem.addActionListener(drawArea);
		saveAsItem.addActionListener(drawArea);
		newItem.addActionListener(drawArea);
		openItem.addActionListener(drawArea);
		fileMenu.add(newItem);
		fileMenu.add(openItem);
		fileMenu.add(saveItem);
		fileMenu.add(saveAsItem);
		menuBar.add(fileMenu);
		JMenu editMenu = new JMenu("Edit");
		JMenuItem undoItem = new JMenuItem("Undo");
		undoItem.addActionListener(drawArea);
		JMenuItem redoItem = new JMenuItem("Redo");
		redoItem.addActionListener(drawArea);
		editMenu.add(undoItem);
		editMenu.add(redoItem);
		menuBar.add(editMenu);
		this.setJMenuBar(menuBar);

		// Add main JPanel to the JFrame
		this.add(mainPanel);
	}

	/**
	 * Start here.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		Paint frame = new Paint();
		int winWidth, winHeight;
		try {
			winWidth = Integer.parseInt(JOptionPane
					.showInputDialog("Enter width of window (min 700):"));
			winHeight = Integer.parseInt(JOptionPane
					.showInputDialog("Enter height of window (min 375):"));
		} catch (Exception e) {
			winWidth = FRAME_WIDTH;
			winHeight = FRAME_HEIGHT;
		}
		if (winWidth < 700) {
			winWidth = FRAME_WIDTH;
		}
		if (winHeight < 375) {
			winHeight = FRAME_HEIGHT;
		}
		frame.setSize(winWidth, winHeight);
		frame.setTitle("Paint");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);
		frame.setVisible(true);
	}

}
