import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;

/**
 * A button that stores a color.
 * 
 * @author Joel Carlson and Ty Strayer. Created Apr 4, 2008.
 */
public class ColorButton extends JButton implements MouseListener {

	private Color color;

	private DrawableArea drawArea;

	private PalleteBar palleteBar;

	/**
	 * Creates a button and stores the color of the button.
	 * 
	 * @param color
	 *            The color of the button.
	 * @param drawArea
	 *            The drawable area which the button affects.
	 * @param palleteBar
	 *            The PalleteBar in which the button resides.
	 */
	public ColorButton(Color color, DrawableArea drawArea, PalleteBar palleteBar) {
		super("     ");
		if (color == null) {
			this.setText("Clear Fill");
		}
		this.color = color;
		this.setBackground(color);
		this.addMouseListener(this);
		this.drawArea = drawArea;
		this.palleteBar = palleteBar;
	}

	public void mouseClicked(MouseEvent e) {
		if (e.getButton() == 1) {
			if (this.color != null) {
				this.drawArea.setOutlineColor(this.color);
				this.palleteBar.setOutlineColor(this.color);
			} else {
				this.drawArea.setFillColor(null);
				this.palleteBar.setFillColor(null);
			}
		} else if (e.getButton() == 2) {
			// nothing
		} else if (e.getButton() == 3) {
			this.drawArea.setFillColor(this.color);
			this.palleteBar.setFillColor(this.color);
		}
	}

	public void mouseEntered(MouseEvent e) {
		// Empty
	}

	public void mouseExited(MouseEvent e) {
		// Empty
	}

	public void mousePressed(MouseEvent e) {
		// Empty
	}

	public void mouseReleased(MouseEvent e) {
		// Empty
	}
}
