import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import javax.swing.JPanel;


/**
 * Displays a tool panel, with tool options, in the Paint frame.
 *
 * @author swansom1.
 *         Created Apr 8, 2008.
 */
public class ToolPanel extends JPanel implements MouseMotionListener {
	
	
	private ToolButtonPanel toolButtonPanel = new ToolButtonPanel();
	private CanvasPanel canvas;
	private ColorPanel colors;
	private DisplayPanel display = new DisplayPanel();
	
	/**
	 * Create the tool panel.
	 *
	 * @param canvas 
	 */
	ToolPanel(CanvasPanel canvas) {
		super();
		this.setLayout(new FlowLayout());
		this.canvas = canvas;
		this.add(this.toolButtonPanel);
		this.toolButtonPanel.setCanvas(this.canvas);
		this.add(this.display);
		this.setPreferredSize(new Dimension(100,600));
		this.addMouseMotionListener(this);
		this.addMouseWheelListener(this.canvas);
	}
	
	/**
	 *
	 * @return The ToolButtonPanel
	 */
	public ToolButtonPanel getToolButtonPanel(){
		return this.toolButtonPanel;
	}
	
	/**
	 *
	 * @return The DisplayPanel
	 */
	public DisplayPanel getDisplayPanel() {
		return this.display;
	}
	
	/**
	 * Sets ColorPanel
	 * 
	 * @param colors
	 */
	public void setColor(ColorPanel colors) {
		this.colors = colors;
	}

	public void mouseDragged(MouseEvent e) {
		// empty
		
	}

	public void mouseMoved(MouseEvent e) {
		this.canvas.setColor(this.colors.getColorChooser().getColor());
	}


}
