import java.awt.geom.Line2D;
import java.awt.geom.Path2D;


/**
 * Pencil Tool
 *
 * @author Richard Stover.
 *         Created Apr 9, 2008.
 */
public class Pencil implements Tools{

	private Path2D path;
	
	/**
	 * creates the Pencil
	 *
	 * @param x
	 * @param y
	 */
	public Pencil(int x, int y) {
		Line2D line = new Line2D.Double(x,y,x,y);
		this.path = new Path2D.Double(line);
	}

	/**
	 * draws the Pencil
	 *
	 * @param x
	 * @param y
	 * @return Line drawn with pencil in Path2D
	 */
	public Object draw(int x, int y) {
		this.path.lineTo(x,y);
		return this.path;
	}

	/**
	 *returns the stroke size of the pencil
	 *
	 * @return The size of the stroke
	 */
	public int getStroke() {
		return 1;
	}

}
