import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * Displays options for the currently selected tool in the ToolPanel.
 *
 * @author swansom1.
 *         Created Apr 8, 2008.
 */
public class DisplayPanel extends JPanel implements ActionListener, ChangeListener {
	
	private static final int STROKE_MAX = 10;
	private static final int STROKE_MIN = 1;
	private static final int INIT = 1;
	private static final int DENSITY_MAX = 3;
	private static final int DENSITY_MIN = 1;
	private JSlider strokeSlider;
	private JSlider sprayDensity;
	private CanvasPanel canvas;
	
	/**
	 * Create display panel
	 *
	 */
	DisplayPanel() {
		super();
		this.setPreferredSize(new Dimension(100,200));
		JLabel strokeLabel = new JLabel("Brush Size", SwingConstants.CENTER);
		JLabel sprayLabel = new JLabel("Spray Density", SwingConstants.CENTER);
		this.strokeSlider = new JSlider(SwingConstants.HORIZONTAL, STROKE_MIN, STROKE_MAX, INIT);
		this.strokeSlider.setSnapToTicks(true);
		this.strokeSlider.setPreferredSize(new Dimension(100,60));
		this.strokeSlider.setMajorTickSpacing(9);
		this.strokeSlider.setMinorTickSpacing(1);
		this.strokeSlider.setPaintTicks(true);
		this.strokeSlider.setPaintLabels(true);
		this.strokeSlider.addChangeListener(this);
		this.sprayDensity = new JSlider(SwingConstants.HORIZONTAL, DENSITY_MIN, DENSITY_MAX, INIT);
		this.sprayDensity.setSnapToTicks(true);
		this.sprayDensity.setPreferredSize(new Dimension(100,60));
		this.sprayDensity.setMajorTickSpacing(1);
		this.sprayDensity.setMinimum(1);
		this.sprayDensity.setPaintTicks(true);
		this.sprayDensity.setPaintLabels(true);
		this.sprayDensity.addChangeListener(this);
		this.add(sprayLabel);
		this.add(this.sprayDensity);
		this.add(strokeLabel);
		this.add(this.strokeSlider);
	}
	
	/**
	 * Sets canvas for display
	 *
	 * @param canvas
	 */
	public void setCanvas(CanvasPanel canvas) {
		this.canvas = canvas;
	}

	public void actionPerformed(ActionEvent e) {
		//empty
	}

	public void stateChanged(ChangeEvent e) {
		JSlider source = (JSlider)e.getSource();
		if(source.getMaximum() == this.strokeSlider.getMaximum()){
			if(!source.getValueIsAdjusting()) {
				this.canvas.setStroke(source.getValue());
			}
		}else{
			if(!source.getValueIsAdjusting()) {
				this.canvas.setDensity(source.getValue());
			}
		}
	}

	/**
	 * syncs the slider with the mouse wheel
	 *
	 * @param wheelRotation
	 */
	public void setSlider(int wheelRotation) {
		if(this.strokeSlider.getValue() - wheelRotation > STROKE_MAX){
			this.strokeSlider.setValue(STROKE_MAX);
		}else if(this.strokeSlider.getValue() - wheelRotation < STROKE_MIN){
			this.strokeSlider.setValue(STROKE_MIN);
		}else{
			this.strokeSlider.setValue(this.strokeSlider.getValue()- wheelRotation);
		}
	}

	/**
	 * syncs the slider with the mouse wheel
	 *
	 * @param wheelRotation
	 */
	public void setDensity(int wheelRotation) {
		if(this.sprayDensity.getValue() - wheelRotation > DENSITY_MAX){
			this.sprayDensity.setValue(STROKE_MAX);
		}else if(this.sprayDensity.getValue() - wheelRotation < DENSITY_MIN){
			this.sprayDensity.setValue(STROKE_MIN);
		}else{
			this.sprayDensity.setValue(this.sprayDensity.getValue()- wheelRotation);
		}
	}

}
