
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;


/**
 * This class creates our frame and adds all our panels to it, allowing us to play.
 *
 * @author Bryce Borchers and Casimir Ksiazek.
 *         Started work 3/27/2008.
 */
public class Paint extends JFrame {

	private static final int FRAME_WIDTH = 1300;
	private static final int FRAME_HEIGHT = 1300;
	
	/**
	 * Panel that shows the type of object to be drawn.
	 */
	protected static PreviewArea preview;

	/**
	 * Start here.
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		new Paint();
	}
	
	/**
	 * Makes our frame and adds components where they should be.
	 *
	 */
	public Paint() {
		
		//Standard frame stuff.
		this.setSize(FRAME_WIDTH,FRAME_HEIGHT);
		this.setTitle("Paint - Team 101");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
 		Paint.preview = new PreviewArea();
		
		JPanel pane = new JPanel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		
		
		//Adds our button panel.
		ButtonPanel clickTool = new ButtonPanel();
		c.weightx = 0;
		c.weighty = 0;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridx = 0;
		c.gridy = 0;
		pane.add(clickTool, c);
		 		
 		//Adds our preveiw area.
 		c.ipadx = 200;
 		c.ipady = 200;
 		c.fill = GridBagConstraints.HORIZONTAL;
 		c.gridx = 0;
 		c.gridy = 7;
 		c.gridwidth = 2;
 		pane.add(preview, c);
	
 		//Adds our draw ares.
		DrawArea drawnOn = new DrawArea();
		c.ipady = 600;
		c.ipadx = 400;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1;
		c.weighty = 1;
		c.gridheight = 5;
		c.gridx = 1;
		c.gridy = 0;
		pane.add(drawnOn, c);
		
		//Adds our slider label.
		JLabel sliderLabel = new JLabel("Size                                                  Red RGB Value                                              Green RGB Value                                         Blue RGB Value", SwingConstants.CENTER);
		c.weightx = 0;
		c.weighty = 0;
		c.ipady = 20;
		c.gridx = 1;
		c.gridy = 6;
		c.gridwidth = 2;
		pane.add(sliderLabel, c);
		
		//Adds our sliders.
		SliderPanel sliders = new SliderPanel();
		c.weightx = 1;
		c.weighty = 1;
		c.ipady = 100;
		c.gridwidth = 2;
		c.gridx = 1;
		c.gridy = 7;
 		pane.add(sliders, c);
			
		this.add(pane);
        this.pack();
		this.setVisible(true);
		new HelpFrame();
	}

}
