import javax.swing.*;
import java.awt.*;


public class LightPanel extends JPanel implements Runnable {
	
	private AButton[] button;
	private int buttonArraySize = 4;
	private int size = 0;
	
	private boolean running = false;
	private Thread t;
	private int sleepTime = 400;
	
	public LightPanel (int size) {
		if (size <= 0) {
			size = 1;
		}
		this.size = size;
		setPreferredSize(new Dimension(90, 30));
        setLayout(new GridLayout(1,4));
		placeButton();
	}
	
	private void placeButton() {
		button = new AButton[buttonArraySize];

		for (int i = 0; i < buttonArraySize; i++){
			button[i] = new AButton();
			add(button[i]);
		    button[i].addActionListener(button[i]);
		}
		
	    updateUI();
	}
	
	public void startAnimation() {
		t = new Thread(this);
		t.start();
	}

	public void run(){
		running = true;
		int i = 0;
		while(running) {
			button[i].set();
			try {
				t.sleep(sleepTime);
			} catch (InterruptedException e) {}
			button[i].reset();
			i++;
			if (i==4) {
				i = 0;
			}
		}
	}

	public void stopAnimation(){
		running = false;
	}
	

}
