import java.util.Iterator;

public class LinkedList<E> {
	private Node first;
	private int size;
	
	public LinkedList(){
		this.first = null;
		this.size = 0;
	}
	
	public int size(){
		return size;
	}
	
	public String toString(){
		if (first == null) return "";
		return first.toString();
	}
	
	public Iterator<E> iterator(){
		return new ListIterator(first);
	}
	
//	public String toString(){
//		String temp = "";
//		if (first == null) return "";
//		Node tempNode = first;
//		while (tempNode != null){
//			temp += tempNode.toString() + " ";
//			tempNode = tempNode.getNext();
//		}
//		return temp;
//	}
	

	


	
	public boolean add(Object o){
		if (first == null) {
			first = new Node(o);
			return true;
		}
		Node temp = first;
		while (temp.getNext() != null){
			temp = temp.getNext();
		}
		temp.setNext(new Node(o));
		return true;
	}

	

	
	private class Node {
		private E element;
		private Node next;
		
		public Node(E element){
			this.element = element;
			this.next = null;
		}

		public boolean add(E o) {
			if (next == null){
				next = new Node(o);
				size++;
				return true;
			}
			return next.add(o);
		}
		
		public String toString(){
//			 if (next != null) return element.toString() + " " + next.toString();
//			 return element.toString();
			 if (next == null)  return element.toString();
			 return element.toString() + " " + next.toString();
		}
		
		public int size(){
			 if (next == null)  return 1;
			 return 1 + next.size();
		}

		
		
	}
	
	private class ListIterator implements Iterator<E> {
		private Node current;
		
		public ListIterator(Node first){
			this.current = first;
		}

		public boolean hasNext(){
			return current != null;
		}

		public E next() {
			E temp = current.element;
			current = current.next;
			return temp;
		}

		public void remove() {
			// TODO Auto-generated method stub.
			
		}
		
	}

}
