import static org.junit.Assert.*;

import org.junit.Test;

public class Testing {
	private static int points = 0;
	
	@Test
	public void testConstructor(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		assertEquals(8,l.a.length);
		points += 4;
	}
	
	@Test
	public void testBasicAdd(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		l.add(new Integer(3));
		assertEquals(new Integer(3), l.a[0]);
		l.add(new Integer(4));
		assertEquals(8, l.a.length);
		assertEquals(new Integer(4), l.a[1]);
		l.add(new Integer(5));
		assertEquals(8, l.a.length);
		assertEquals(new Integer(5), l.a[2]);
		points += 6;
	}
	
	@Test
	public void testAddDoubling(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		for (int i = 0; i < 20; i++){
			l.add(new Integer(i));
		}
		for (int i = 0; i < 20; i++){
			assertEquals(new Integer(i), l.a[i]);
		}
		points += 12;
	}
	
	@Test
	public void testSize(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		assertEquals(0, l.size());
		l.add(new Integer(3));
		assertEquals(1, l.size());
		l.add(new Integer(4));
		assertEquals(2, l.size());
		points += 3;
	}	
	
	@Test
	public void testToArray(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		for (int i = 0; i < 6; i++){
			l.add(new Integer(i));
		}
		Object[] temp = l.toArray();
		assertEquals(6, temp.length);
		for (int i = 0; i < 6; i++){
			assertEquals(new Integer(i), l.a[i]);
		}
		points += 7;
	}
	
	@Test
	public void testReverse(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		for (int i = 0; i < 8; i++){
			l.add(new Integer(i));
		}
		l.reverse();
		for (int i = 0; i < 8; i++){
			assertEquals(new Integer(7-i), l.a[i]);
		}
		points += 10;
	}
	
	@Test
	public void testSortedAdd(){
		SortedArrayList<Integer> l = new SortedArrayList<Integer>();
		for (int i = 8; i > 0; i--){

			l.add(new Integer(i));
		}
		for (int i = 1; i <= 8; i++){
			assertEquals(new Integer(i), l.a[i-1]);
		}
		points += 14;
		assertFalse(l.add(new Integer(4)));
		points += 4;
	}
	
	@Test
	public void testNothing(){
		System.out.println(points);
	}
	
}