import static org.junit.Assert.*;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Stack;

import org.junit.Test;

public class Testing {
	private static int points = 0;
	
	@Test
	public void testGetLast(){
		LinkedList<Integer> l = new LinkedList<Integer>();
		assertEquals(null, l.getLast());
		points += 2;
		l.insert(new Integer(3));
		assertEquals(new Integer(3), l.getLast());
		points += 2;
		l.insert(new Integer(4));
		assertEquals(new Integer(4), l.getLast());
		points += 2;
	}

	@Test
	public void testInsertStack(){
		LinkedList<Integer> l = new LinkedList<Integer>();
		Stack<Integer> s = new Stack<Integer>();
		assertTrue(l.insertStack(s));
		assertEquals("", l.toString());
		points += 2;
		s.push(new Integer(3));
		s.push(new Integer(7));
		s.push(new Integer(5));
		assertTrue(l.insertStack(s));
		assertEquals("3 5 7", l.toString());		
		points += 7;
	}
	
	@Test
	public void testInsertAll(){
		LinkedList<Integer> l = new LinkedList<Integer>();
		ArrayList<Integer> a = new ArrayList<Integer>();
		assertTrue(l.insertAll(a));
		assertEquals("", l.toString());
		points += 2;
		a.add(new Integer(3));
		a.add(new Integer(7));
		a.add(new Integer(5));
		assertTrue(l.insertAll(a));
		assertEquals("3 5 7", l.toString());		
		points += 7;
	}
	
	@Test
	public void testToArrayList(){
		LinkedList<Integer> l = new LinkedList<Integer>();
		assertEquals(new ArrayList<Integer>(), l.toArrayList());
		points += 2;
		l.insert(new Integer(3));
		l.insert(new Integer(7));
		l.insert(new Integer(5));
		l.insert(new Integer(9));
		l.insert(new Integer(3));
		ArrayList<Integer> a = new ArrayList<Integer>();
		a.add(3);a.add(3);a.add(5);a.add(7);a.add(9);
		assertEquals(a, l.toArrayList());
		points += 15;
	}

	@Test
	public void testToArray(){
		LinkedList<Integer> l = new LinkedList<Integer>();
		Integer[] a = new Integer[0];
		assertEquals(a, l.toArray());
		points += 2;
		l.insert(new Integer(3));
		l.insert(new Integer(7));
		l.insert(new Integer(5));
		l.insert(new Integer(9));
		l.insert(new Integer(3));
		a = new Integer[5];
		a[0] = 3; a[1] = 3; a[2] = 5; a[3] = 7; a[4] = 9;
		assertEquals(a, l.toArray());
		points += 17;
	}
	
	@Test
	public void testNothing(){
		System.out.println(points);
	}
	
}