import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class LinkedList<E extends Comparable> {
	private Node first;
	private int size;
	
	public LinkedList(){
		this.first = null;
		this.size = 0;
	}
	
	public String toString(){
		if (first == null) return "";
		return first.toString();
	}
	
	/**
	 * This method returns the last element in the LinkedList
	 *
	 * @return E  The element located at the end of the list.
	 */ 
	public E getLast(){}
	
	/**
	 * This method returns an array containing the elements of the
	 * linked list. The method is iterative. 
	 *
	 * @return Object[]  The array returned is of type Object.
	 */ 
	public Object[] toArray(){}
	
	/**
	 * This method returns an ArrayList containing the elements of 
	 * the linked list. The method is recursive. 
	 *
	 * @return ArrayList  The ArrayList returned is of type E.
	 */
	public ArrayList<E> toArrayList(){}
	
	/**
	 * This method inserts a Stack into the linked list.
	 * the linked list. The method is iterative and uses stack 
	 * operations. 
	 * 
	 * @param s  The parameter is a Stack of type E.
	 * 
	 * @return boolean  The method returns true if all elements were
	 * successfully added to the LinkedList.
	 */
	public boolean insertStack(Stack<E> s){}
	
	/**
	 * This method inserts a Collection into the linked list.
	 * 
	 * @param s  A data structure of type E that has an Iterator.
	 * 
	 * @return boolean  The method returns true if all elements were
	 * successfully added to the LinkedList.
	 */
	public boolean insertAll(Iterable<E> s){}
	
	public boolean insert(E o){
		if (first == null) {
			first = new Node(o);
			size++;
			return true;
		}
		return first.insert(o);
	}
	

	
	private class Node {
		private E element;
		private Node next;
		private Node previous;
		
		public Node(E element){
			this.element = element;
			this.next = null;
			this.previous = null;
		}

		
		public boolean insert(E o) {
			if (element.compareTo(o) > 0) {
				Node temp = this;
				if (this == first){
					first = new Node(o);
					size++;
					first.next = temp;
				} else {
					Node toAdd =  new Node(o);
					size++;
					previous.next = toAdd;
					toAdd.next = temp;
					toAdd.previous = previous;
				}
				return true;
			}
			if (next == null){
				next = new Node(o);
				size++;
				next.previous = this;
				return true;
			}
			return next.insert(o);
		}
		
		public String toString(){
			 if (next == null)  return element.toString();
			 return element.toString() + " " + next.toString();
		}
		
	}


}
