import static org.junit.Assert.assertEquals;
import org.junit.Test;

import java.util.ArrayList;

// Give Person class with two fields and constructor.

public class Testing {
	private static int points = 0;
	
	@Test
	public void testStudentConstructor(){
		new Student("Moe", "555-1212", "Stooge", 1.0);
		points += 15;
	}
		
	@Test
	public void testToStringPerson(){
		Person p = new Person("Larry", "877-6000");
		assertEquals("Name: Larry\nPhone number: 877-6000\n",p.toString());
		points += 5;
	}
	
	@Test
	public void testToStringStudent(){
		Student s = new Student("Moe", "555-1212", "Stooge", 1.0);
		assertEquals("Name: Moe\nPhone number: 555-1212\nAIM Name: Stooge\nGPA: 1.0\n",s.toString());
		points += 5;
	}
	
	@Test
	public void testGetName(){
		Person p = new Person("Larry", "877-6000");
		assertEquals("Larry",p.getName());
		points += 5;
	}
	
	@Test
	public void testFind(){
		ArrayList<Person> a = new ArrayList<Person>();
		assertEquals(null, Person.find(a,"Moe"));
		points += 3;
		Person m = new Person("Moe", "877-6000");
		a.add(m);
		a.add(new Student("Moe", "555-1212", "Stooge", 1.0));
		assertEquals(null, Person.find(a,"Shemp"));
		points += 5;
		assertEquals(m, Person.find(a,"Moe"));
		points += 10;
	}
	
	@Test
	public void testHighestGPA(){
		ArrayList<Student> a = new ArrayList<Student>();
		assertEquals(null, Student.highestGPA(a));
		points += 2;
		Student m = new Student("Moe", "555-1212", "Stooge", 1.0);
		a.add(m);
		assertEquals(m, Student.highestGPA(a));
		points += 2;
		Student n = new Student("Larry", "555-1212", "Stooge", 3.0);
		a.add(n);		
		Student k = new Student("Shemp", "555-1212", "Stooge", 2.0);
		a.add(k);	
		assertEquals(n, Student.highestGPA(a));
		points += 8;
	}
	
	@Test
	public void printPoints(){
		System.out.println("Points [out of 60]: " + points);
	}
	
	
}

