package junit4;

import calc.Calculator;
import junit.framework.JUnit4TestAdapter;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@RunWith(Parameterized.class)
/**
 * This class is a parameterized test case. It uses the values define in the collection
 * as a parameter.
 */
public class SquareTest {

    private static Calculator calculator = new Calculator();
    private int param;
    private int result;

    // Used for backward compatibility (IDEs, Ant and JUnit 3 text runner)
//    public static junit.framework.Test suite() {
//        return new JUnit4TestAdapter(SquareTest.class);
//    }
//    public SquareTest() {
//    }

    @Parameters
    public static List param() {
        return Arrays.asList(new Object[][]{
                {0, 0},
                {1, 1},
                {2, 4},
                {4, 16},
                {5, 25},
                {6, 36},
                {7, 48}         // 7 = 49 not 48
        });
    }

    public SquareTest(int param, int result) {
        this.param = param;
        this.result = result;
    }

    //==================================
    //=            Test cases          =
    //==================================
    @Test
    public void square() {
        calculator.square(param);
        assertEquals(result, calculator.getResult());
    }
}
