import java.math.BigInteger;

public class Factorial_9_InputErrors {

   public static BigInteger factorial(int n) {
      if (n < 0)
         throw new IllegalArgumentException();
      BigInteger prod = BigInteger.ONE;
      for (int i = 1; i <= n; i++)
         prod = prod.multiply(new BigInteger(i + ""));
      return prod;
   }

   public static void main(String[] args) {
      try {
         int n = Integer.parseInt(args[0]);
         System.out.println(n + "! = " + factorial(n));
      } catch (ArrayIndexOutOfBoundsException e) {
         System.out.println("Command-line argument required");
      } catch (NumberFormatException e) {
         System.out.println("Argument must be an integer");
      } catch (IllegalArgumentException e) {
         System.out.println("Factorial arg cannot be negative");
      }
   }
}
