import junit.framework.TestCase;

public class CashRegisterTest extends TestCase
{
   public void testSimpleCase()
   {
      CashRegister register = new CashRegister();
      register.recordPurchase(0.75);
      register.recordPurchase(1.50);
      register.enterPayment(2, 0, 5, 0, 0);
      double expected = 0.25;
      assertEquals(expected, register.giveChange(), EPSILON);
   }

   public void testZeroBalance() 
   {
      CashRegister register = new CashRegister();
      register.recordPurchase(2.25);
      register.recordPurchase(19.25);
      register.enterPayment(21, 2, 0, 0, 0);
      assertEquals(0, register.giveChange(), EPSILON);
   }

   // More test cases 
   // . . .

   private static final double EPSILON = 1E-12;
}
