import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;


/**
 * Pencil tool used for drawing points and thin lines
 *
 * @author Matt Drosos and Colin DeClue.
 *         Created Apr 9, 2008.
 */
public class Pencil implements Tool {
	/**
	 * an array of shapes to be drawn
	 */
	protected ArrayList<Shape> shapes;
	private boolean previousBool;
	private Point2D.Double previousPoint;
	
	/**
	 * an arrayList of boolean values to determine if an ArrayList<Shape> should be filled
	 */
	protected ArrayList<Boolean> fill;
	/**
	 * an ArrayList of Colors to determine the Color of an ArrayList<Shape>
	 */
	protected ArrayList<Color> color;
	/**
	 * alllows a relationship between the colorPanel and Tool
	 */
	protected ColorPanel colorPanel;
	/**
	 * used to determine if the colorPanel should be filled
	 */
	protected boolean toFill;
	
	
	/**
	 * creates a Pencil Tool
	 *
	 * @param shapes - an ArrayList<Shape> of shapes 
	 * @param fill - a boolean ArrayList which keeps track of if the shape should be filled
	 * @param color - an ArrayList<Color> of colors associated with each shape
	 * @param colorPanel - the color panel that allows communication between the ColorPanel and the tool
	 */
	public Pencil(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel)
	{
		this.fill = fill;
		this.toFill = false;
		this.color = color;
		this.colorPanel = colorPanel;
		this.shapes = shapes;
		this.previousBool = false;
	}

	public void clicked(MouseEvent event) {
		
		this.shapes.add(new Ellipse2D.Double(event.getX(), event.getY(), 1,1));
		this.fill.add(true);
		this.color.add(this.colorPanel.getCurrentColor());
		this.previousBool=false;
	}

	public void dragged(MouseEvent event) {
		
		this.shapes.add(new Line2D.Double(event.getX(), event.getY(),event.getX(), event.getY()));
		if(this.previousBool)
		{
			this.shapes.add(new Line2D.Double(new Point2D.Double(this.previousPoint.getX(), this.previousPoint.getY()), new Point2D.Double(event.getPoint().getX(),event.getPoint().getY())));
			this.fill.add(this.toFill);
			this.color.add(this.colorPanel.getCurrentColor());
		}
		this.previousPoint = new Point2D.Double(event.getPoint().getX(),event.getPoint().getY());
		this.fill.add(this.toFill);
		this.color.add(this.colorPanel.getCurrentColor());
		this.previousBool = true;
		
//		this.shapes.add(new Ellipse2D.Double(event.getX() - .25, event.getY() - .25, .5,.5));
//		this.fill.add(true);
//		this.color.add(this.colorPanel.getCurrentColor());
	}

	public void pressed(MouseEvent event) {
//		this.shapes.add(new Line2D.Double(event.getX(), event.getY(),event.getX(), event.getY()));
		this.shapes.add(new Ellipse2D.Double(event.getX(), event.getY(), .5,.5));
		this.fill.add(this.toFill);
		this.color.add(this.colorPanel.getCurrentColor());
	}

	public void release(MouseEvent event) {
		this.previousBool = false;
		this.shapes.add(new Ellipse2D.Double(event.getX(), event.getY(), 1,1));
		this.fill.add(this.toFill);
		this.color.add(this.colorPanel.getCurrentColor());
	}
		
	
}
