import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Random;


/**
 * a spray can that draws random circles in a given area
 *
 * @author Matthew Drosos and Colin DeClue.
 *         Created Apr 9, 2008.
 */
public class GraffitiCan extends Pencil {
	
	private Random generator;

	/**
	 * creates a spray can
	 *
	 * @param shapes - an ArrayList of shapes drawn to the panel
	 * @param fill - an ArrayList of booleans that determine if the shape should be filled
	 * @param color - an ArrayList of colors of the corresponding shapes
	 * @param colorPanel - allows access to color panel functions
	 * @param panels - an ArrayList of panels in the WorldPanel
	 */
	public GraffitiCan(ArrayList<Shape> shapes, ArrayList<Boolean> fill, ArrayList<Color> color, ColorPanel colorPanel) {
		super(shapes, fill, color, colorPanel);
		this.generator = new Random();
	}
	@Override
	public void pressed(MouseEvent event)
	{
		for(int i =0; i < 10; i++)
		{
			this.shapes.add(new Ellipse2D.Double((this.generator.nextInt(40)+(event.getX()-20)),(this.generator.nextInt(40)+(event.getY()-20)),4,4));
			this.fill.add(true);
			this.color.add(this.colorPanel.getCurrentColor());
		}
	}
	@Override
	public void clicked(MouseEvent event)
	{
		for(int i =0; i < 10; i++)
		{
			this.shapes.add(new Ellipse2D.Double((this.generator.nextInt(40)+(event.getX()-20)),(this.generator.nextInt(40)+(event.getY()-20)),4,4));
			this.fill.add(true);
			this.color.add(this.colorPanel.getCurrentColor());
		}
	}
	@Override
	public void dragged(MouseEvent event)
	{
		for(int i =0; i < 10; i++)
		{
			this.shapes.add(new Ellipse2D.Double((this.generator.nextInt(40)+(event.getX()-20)),(this.generator.nextInt(40)+(event.getY()-20)),4,4));
			this.fill.add(true);
			this.color.add(this.colorPanel.getCurrentColor());
		}
	}

}
