import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Creates the panel of buttons used to draw shapes and change
 * the drawing tool
 *
 * @author Annmarie Stanley and Hannah Chadd.
 *         Created Mar 30, 2008.
 */
public class DrawingPanel extends JPanel {

	private static final int numButtons = 6;
	public static JButton drawTool;
	
	/**
	 * Creates the panel of buttons used to draw shapes and change
	 * the drawing tool
	 *
	 * @param args
	 */
	
	
	public DrawingPanel() {
		this.add(new JLabel("Drawing Toolbar"));
		
		JPanel drawPanel = new JPanel();
		drawPanel.setLayout(new GridLayout(numButtons, 1));
		
		ovalButton oval = new ovalButton();
		oval.addMouseListener(oval);
		drawPanel.add(oval);
		rectButton rect = new rectButton();
		rect.addMouseListener(rect);
		drawPanel.add(rect);
		polyButton poly = new polyButton();
		poly.addActionListener(poly);
		drawPanel.add(poly);
		fillButton fill = new fillButton();
		fill.addMouseListener(fill);
		drawPanel.add(fill);
		brushButton brush = new brushButton();
		brush.addMouseListener(brush);
		drawPanel.add(brush);
		pencilButton penc = new pencilButton();
		penc.addMouseListener(penc);
		drawPanel.add(penc);
		lineButton line = new lineButton();
		line.addMouseListener(line);
		drawPanel.add(line);
		eraserButton eraser = new eraserButton();
		eraser.addMouseListener(eraser);
		drawPanel.add(eraser);
		undoButton undo = new undoButton();
		undo.addMouseListener(undo);
		drawPanel.add(undo);
		sprayButton spray = new sprayButton();
		spray.addMouseListener(spray);
		drawPanel.add(spray);
					
		this.add(drawPanel);
	}
}