
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JPanel;


/**
 * The canvas that is being drawn on.
 *
 * @author LPrestonSegoIII
 * 		   Kyle Harris
 *         Created Mar 27, 2008.
 */
public class CanvasComponent extends JPanel implements MouseListener, MouseMotionListener{
	
	private Point lastMousePos;
	private String activeTool = "Pencil";
	private int brushSize = 2;
	private Color chosenColor = Color.BLACK;
	private Graphics g2 = getGraphics();
	private ArrayList polyArray = new ArrayList<Point>();
	private int count = 0;
	
	/**
	 * Constructor.
	 * @param paint 
	 * @param toolsComponent 
	 *
	 */
	public CanvasComponent() {
		super();
		addMouseMotionListener(this);
		addMouseListener(this);
	}
	
	@Override
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		addMouseMotionListener(this);
		addMouseListener(this);

	}
    
	public void mouseClicked(MouseEvent e) {
		// Nothing
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}

	@SuppressWarnings("unchecked")
	public void mousePressed(MouseEvent e) {
		this.count++;
		if (this.count > 1) {
			Graphics g = getGraphics(); 
			this.g2 = g;
			this.g2.setColor(this.chosenColor);
			this.count = 0;
			if (e.getButton() == 1) {
				if(this.activeTool.equals("Polygon")){
					this.polyArray.add(e.getPoint());
					if(this.polyArray.size() > 1){
						for (int i = 0; i < this.polyArray.size() - 1; i++){
							Point firstPoint = ((Point)this.polyArray.get(i));
							Point secondPoint = ((Point)this.polyArray.get(i+1));
							this.g2.drawLine(firstPoint.x, firstPoint.y, secondPoint.x, secondPoint.y);
						}
					}
				} else if (this.activeTool.equals("Pencil")) {
					this.g2.fillOval(this.lastMousePos.x - this.brushSize/2, this.lastMousePos.y - this.brushSize/2, 1, 1);
				} else if (this.activeTool.equals("Paint Brush")) {
					this.g2.fillOval(this.lastMousePos.x - this.brushSize/2, this.lastMousePos.y - this.brushSize/2, this.brushSize, this.brushSize);
				}
			} else if (e.getButton() == 3 && this.activeTool.equals("Polygon")) {
				Point p1 = (Point) this.polyArray.get(0);
				Point p2 = (Point) this.polyArray.get(this.polyArray.size() - 1);
				this.g2.drawLine(p1.x, p1.y, p2.x, p2.y);
				this.polyArray.clear();
			}
		} else {
			this.lastMousePos = e.getPoint();
		}
	}
	
	
	
	public void mouseReleased(MouseEvent e) {
		Point p = e.getPoint();
		Point firstPoint = new Point(Math.min(p.x, this.lastMousePos.x), Math.min(p.y, this.lastMousePos.y));
		if(this.activeTool.equals("Rectangle")){ 
			for (int i = 0; i < this.brushSize /2; i++) {
				this.g2.drawRect(firstPoint.x + i, firstPoint.y + i, Math.abs(p.x - this.lastMousePos.x) - 2*i, Math.abs(p.y - this.lastMousePos.y) - 2*i);
			}
			
			
		}
		else if(this.activeTool.equals("Ellipse")){
			for (int i = 0; i < this.brushSize/2; i++){
				this.g2.drawOval(firstPoint.x + i, firstPoint.y + i, Math.abs(p.x - this.lastMousePos.x) - 2*i, Math.abs(p.y - this.lastMousePos.y) - 2*i);
			}
		}
	}

	public void mouseDragged(MouseEvent e) {
		Point p = e.getPoint();
		Graphics g = getGraphics(); 
		this.g2 = g;
		if (this.activeTool.equals("Eraser")) {
			g.setColor(Color.WHITE); 
		} else g.setColor(this.chosenColor);
		
		if (this.activeTool.equals("Pencil")){
			g.drawLine(this.lastMousePos.x, this.lastMousePos.y, p.x, p.y);
		} 
		else if (this.activeTool.equals("Paint Brush") || this.activeTool.equals("Eraser")){
			for (int i = 0; i < p.distance(this.lastMousePos); i++){
				double dy = i * Math.sin(Math.atan2(this.lastMousePos.y - p.y, this.lastMousePos.x - p.x));
				double dx = i * Math.cos(Math.atan2(this.lastMousePos.y - p.y, this.lastMousePos.x - p.x));
				g.fillOval((int)dx + p.x - this.brushSize/2, (int)dy + p.y - this.brushSize/2, this.brushSize, this.brushSize);

			}
		} else if (this.activeTool.equals("Spray Paint")) {
			for (int i = 0; i < (this.brushSize/10) + 2; i++) {
				this.g2.drawOval((int) (Math.random() * this.brushSize + p.x) - this.brushSize/2, (int) (Math.random() * this.brushSize + p.y) - this.brushSize/2, 1, 1);
			}
		}
		if(this.activeTool.equals("Rectangle") || this.activeTool.equals("Ellipse")){
			/*nothing here*/
			} else {
				this.lastMousePos = p;
				}
	}

	public void mouseMoved(MouseEvent e) {
		// TODO Auto-generated method stub.
		
	}
	
	/**
	 * Chooses the current tool being used in the canvas.
	 *
	 * @param tool
	 */
	public void chooseTool(String tool) {
		this.activeTool = tool;
	}

	/**
	 * Chooses the current brush size.
	 *
	 * @param brushSize2
	 */
	public void changeBrushSize(int brushSize2) {
		this.brushSize = brushSize2;
		
	}
	
	/**
	 * Sets the Color
	 *
	 * @param color
	 */
	public void changeChosenColor(Color color){
		this.chosenColor = color;
		this.getGraphics().setColor(this.chosenColor);
	}


	/**
	 * Sets the image.
	 *
	 * @param image
	 */
	public void setImage(BufferedImage image) {
		Graphics g = getGraphics(); 
		this.g2 = g;
		this.g2.drawImage(image, 0, 0, this);
	}

	/**
	 * Changes the canvas' size.
	 * @param x The x size.
	 * @param y The y size.
	 *
	 */
	public void changeCanvasSize(int x, int y) {
		super.setSize(x, y);
		
	}

	
}
