package ballworlds.framework;

import java.awt.Color;
import java.awt.Shape;

/**
 * A Drawable is an object that can be drawn onto a Graphics object,
 * by returning its Shape and Color.
 *
 * @author David Mutchler, Salman Azhar and others, January 2005.
 * Modified September, 2008.
 */
public interface Drawable {

	/**
	 * Returns the Shape (which contains position and size) of this Drawable.
	 *
	 * @return the Shape of this Drawable
	 */
	public Shape getShape();

	/**
	 * Returns the Color of this Drawable.
	 *
	 * @return the Color of this Drawable
	 */
	public Color getColor();
}
